/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworkscm.transform.AccountAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountAttribute> {
    private final String name;
    private final Integer maximum;
    private final Integer used;

    private AccountAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.maximum = builder.maximum;
        this.used = builder.used;
    }

    public String name() {
        return this.name;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public Integer used() {
        return this.used;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.used());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.used(), other.used());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("Maximum: ").append(this.maximum()).append(",");
        }
        if (this.used() != null) {
            sb.append("Used: ").append(this.used()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Maximum": {
                return Optional.of(clazz.cast(this.maximum()));
            }
            case "Used": {
                return Optional.of(clazz.cast(this.used()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer maximum;
        private Integer used;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            this.name(model.name);
            this.maximum(model.maximum);
            this.used(model.used);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getUsed() {
            return this.used;
        }

        @Override
        public final Builder used(Integer used) {
            this.used = used;
            return this;
        }

        public final void setUsed(Integer used) {
            this.used = used;
        }

        public AccountAttribute build() {
            return new AccountAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountAttribute> {
        public Builder name(String var1);

        public Builder maximum(Integer var1);

        public Builder used(Integer var1);
    }
}

