/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworkscm.model.BackupStatus;
import software.amazon.awssdk.services.opsworkscm.model.BackupType;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.services.opsworkscm.transform.BackupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Backup
implements StructuredPojo,
ToCopyableBuilder<Builder, Backup> {
    private final String backupArn;
    private final String backupId;
    private final String backupType;
    private final Instant createdAt;
    private final String description;
    private final String engine;
    private final String engineModel;
    private final String engineVersion;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Integer s3DataSize;
    private final String s3DataUrl;
    private final String s3LogUrl;
    private final List<String> securityGroupIds;
    private final String serverName;
    private final String serviceRoleArn;
    private final String status;
    private final String statusDescription;
    private final List<String> subnetIds;
    private final String toolsVersion;
    private final String userArn;

    private Backup(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupId = builder.backupId;
        this.backupType = builder.backupType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.s3DataSize = builder.s3DataSize;
        this.s3DataUrl = builder.s3DataUrl;
        this.s3LogUrl = builder.s3LogUrl;
        this.securityGroupIds = builder.securityGroupIds;
        this.serverName = builder.serverName;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.subnetIds = builder.subnetIds;
        this.toolsVersion = builder.toolsVersion;
        this.userArn = builder.userArn;
    }

    public String backupArn() {
        return this.backupArn;
    }

    public String backupId() {
        return this.backupId;
    }

    public BackupType backupType() {
        return BackupType.fromValue(this.backupType);
    }

    public String backupTypeString() {
        return this.backupType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public String engine() {
        return this.engine;
    }

    public String engineModel() {
        return this.engineModel;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer s3DataSize() {
        return this.s3DataSize;
    }

    public String s3DataUrl() {
        return this.s3DataUrl;
    }

    public String s3LogUrl() {
        return this.s3LogUrl;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public BackupStatus status() {
        return BackupStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDescription() {
        return this.statusDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String toolsVersion() {
        return this.toolsVersion;
    }

    public String userArn() {
        return this.userArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.backupArn() == null ? 0 : this.backupArn().hashCode());
        hashCode = 31 * hashCode + (this.backupId() == null ? 0 : this.backupId().hashCode());
        hashCode = 31 * hashCode + (this.backupTypeString() == null ? 0 : this.backupTypeString().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineModel() == null ? 0 : this.engineModel().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileArn() == null ? 0 : this.instanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.keyPair() == null ? 0 : this.keyPair().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.s3DataSize() == null ? 0 : this.s3DataSize().hashCode());
        hashCode = 31 * hashCode + (this.s3DataUrl() == null ? 0 : this.s3DataUrl().hashCode());
        hashCode = 31 * hashCode + (this.s3LogUrl() == null ? 0 : this.s3LogUrl().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusDescription() == null ? 0 : this.statusDescription().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.toolsVersion() == null ? 0 : this.toolsVersion().hashCode());
        hashCode = 31 * hashCode + (this.userArn() == null ? 0 : this.userArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        if (other.backupArn() == null ^ this.backupArn() == null) {
            return false;
        }
        if (other.backupArn() != null && !other.backupArn().equals(this.backupArn())) {
            return false;
        }
        if (other.backupId() == null ^ this.backupId() == null) {
            return false;
        }
        if (other.backupId() != null && !other.backupId().equals(this.backupId())) {
            return false;
        }
        if (other.backupTypeString() == null ^ this.backupTypeString() == null) {
            return false;
        }
        if (other.backupTypeString() != null && !other.backupTypeString().equals(this.backupTypeString())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineModel() == null ^ this.engineModel() == null) {
            return false;
        }
        if (other.engineModel() != null && !other.engineModel().equals(this.engineModel())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.instanceProfileArn() == null ^ this.instanceProfileArn() == null) {
            return false;
        }
        if (other.instanceProfileArn() != null && !other.instanceProfileArn().equals(this.instanceProfileArn())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        if (other.keyPair() != null && !other.keyPair().equals(this.keyPair())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.s3DataSize() == null ^ this.s3DataSize() == null) {
            return false;
        }
        if (other.s3DataSize() != null && !other.s3DataSize().equals(this.s3DataSize())) {
            return false;
        }
        if (other.s3DataUrl() == null ^ this.s3DataUrl() == null) {
            return false;
        }
        if (other.s3DataUrl() != null && !other.s3DataUrl().equals(this.s3DataUrl())) {
            return false;
        }
        if (other.s3LogUrl() == null ^ this.s3LogUrl() == null) {
            return false;
        }
        if (other.s3LogUrl() != null && !other.s3LogUrl().equals(this.s3LogUrl())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusDescription() == null ^ this.statusDescription() == null) {
            return false;
        }
        if (other.statusDescription() != null && !other.statusDescription().equals(this.statusDescription())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.toolsVersion() == null ^ this.toolsVersion() == null) {
            return false;
        }
        if (other.toolsVersion() != null && !other.toolsVersion().equals(this.toolsVersion())) {
            return false;
        }
        if (other.userArn() == null ^ this.userArn() == null) {
            return false;
        }
        return other.userArn() == null || other.userArn().equals(this.userArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.backupArn() != null) {
            sb.append("BackupArn: ").append(this.backupArn()).append(",");
        }
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        if (this.backupTypeString() != null) {
            sb.append("BackupType: ").append(this.backupTypeString()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineModel() != null) {
            sb.append("EngineModel: ").append(this.engineModel()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.instanceProfileArn()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.s3DataSize() != null) {
            sb.append("S3DataSize: ").append(this.s3DataSize()).append(",");
        }
        if (this.s3DataUrl() != null) {
            sb.append("S3DataUrl: ").append(this.s3DataUrl()).append(",");
        }
        if (this.s3LogUrl() != null) {
            sb.append("S3LogUrl: ").append(this.s3LogUrl()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDescription() != null) {
            sb.append("StatusDescription: ").append(this.statusDescription()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.toolsVersion() != null) {
            sb.append("ToolsVersion: ").append(this.toolsVersion()).append(",");
        }
        if (this.userArn() != null) {
            sb.append("UserArn: ").append(this.userArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupArn": {
                return Optional.of(clazz.cast(this.backupArn()));
            }
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
            case "BackupType": {
                return Optional.of(clazz.cast(this.backupTypeString()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.of(clazz.cast(this.engineModel()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "InstanceProfileArn": {
                return Optional.of(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.of(clazz.cast(this.keyPair()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "S3DataSize": {
                return Optional.of(clazz.cast(this.s3DataSize()));
            }
            case "S3DataUrl": {
                return Optional.of(clazz.cast(this.s3DataUrl()));
            }
            case "S3LogUrl": {
                return Optional.of(clazz.cast(this.s3LogUrl()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDescription": {
                return Optional.of(clazz.cast(this.statusDescription()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "ToolsVersion": {
                return Optional.of(clazz.cast(this.toolsVersion()));
            }
            case "UserArn": {
                return Optional.of(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupArn;
        private String backupId;
        private String backupType;
        private Instant createdAt;
        private String description;
        private String engine;
        private String engineModel;
        private String engineVersion;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Integer s3DataSize;
        private String s3DataUrl;
        private String s3LogUrl;
        private List<String> securityGroupIds;
        private String serverName;
        private String serviceRoleArn;
        private String status;
        private String statusDescription;
        private List<String> subnetIds;
        private String toolsVersion;
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupArn(model.backupArn);
            this.backupId(model.backupId);
            this.backupType(model.backupType);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineVersion(model.engineVersion);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.s3DataSize(model.s3DataSize);
            this.s3DataUrl(model.s3DataUrl);
            this.s3LogUrl(model.s3LogUrl);
            this.securityGroupIds(model.securityGroupIds);
            this.serverName(model.serverName);
            this.serviceRoleArn(model.serviceRoleArn);
            this.status(model.status);
            this.statusDescription(model.statusDescription);
            this.subnetIds(model.subnetIds);
            this.toolsVersion(model.toolsVersion);
            this.userArn(model.userArn);
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupType() {
            return this.backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getS3DataSize() {
            return this.s3DataSize;
        }

        @Override
        public final Builder s3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
            return this;
        }

        public final void setS3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
        }

        public final String getS3DataUrl() {
            return this.s3DataUrl;
        }

        @Override
        public final Builder s3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
            return this;
        }

        public final void setS3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
        }

        public final String getS3LogUrl() {
            return this.s3LogUrl;
        }

        @Override
        public final Builder s3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
            return this;
        }

        public final void setS3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BackupStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDescription() {
            return this.statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getToolsVersion() {
            return this.toolsVersion;
        }

        @Override
        public final Builder toolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
            return this;
        }

        public final void setToolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public Backup build() {
            return new Backup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Backup> {
        public Builder backupArn(String var1);

        public Builder backupId(String var1);

        public Builder backupType(String var1);

        public Builder backupType(BackupType var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineVersion(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder s3DataSize(Integer var1);

        public Builder s3DataUrl(String var1);

        public Builder s3LogUrl(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serverName(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(BackupStatus var1);

        public Builder statusDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder toolsVersion(String var1);

        public Builder userArn(String var1);
    }
}

