/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateNodeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateNodeRequest> {
    private final String serverName;
    private final String nodeName;
    private final List<EngineAttribute> engineAttributes;

    private AssociateNodeRequest(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.nodeName = builder.nodeName;
        this.engineAttributes = builder.engineAttributes;
    }

    public String serverName() {
        return this.serverName;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.nodeName() == null ? 0 : this.nodeName().hashCode());
        hashCode = 31 * hashCode + (this.engineAttributes() == null ? 0 : this.engineAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNodeRequest)) {
            return false;
        }
        AssociateNodeRequest other = (AssociateNodeRequest)((Object)obj);
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.nodeName() == null ^ this.nodeName() == null) {
            return false;
        }
        if (other.nodeName() != null && !other.nodeName().equals(this.nodeName())) {
            return false;
        }
        if (other.engineAttributes() == null ^ this.engineAttributes() == null) {
            return false;
        }
        return other.engineAttributes() == null || other.engineAttributes().equals(this.engineAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.nodeName() != null) {
            sb.append("NodeName: ").append(this.nodeName()).append(",");
        }
        if (this.engineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.engineAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "NodeName": {
                return Optional.of(clazz.cast(this.nodeName()));
            }
            case "EngineAttributes": {
                return Optional.of(clazz.cast(this.engineAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private String nodeName;
        private List<EngineAttribute> engineAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateNodeRequest model) {
            this.serverName(model.serverName);
            this.nodeName(model.nodeName);
            this.engineAttributes(model.engineAttributes);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        public AssociateNodeRequest build() {
            return new AssociateNodeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateNodeRequest> {
        public Builder serverName(String var1);

        public Builder nodeName(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);
    }
}

