/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworkscm.model.Backup;
import software.amazon.awssdk.services.opsworkscm.model.BackupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBackupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeBackupsResponse> {
    private final List<Backup> backups;
    private final String nextToken;

    private DescribeBackupsResponse(BuilderImpl builder) {
        this.backups = builder.backups;
        this.nextToken = builder.nextToken;
    }

    public List<Backup> backups() {
        return this.backups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.backups() == null ? 0 : this.backups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsResponse)) {
            return false;
        }
        DescribeBackupsResponse other = (DescribeBackupsResponse)((Object)obj);
        if (other.backups() == null ^ this.backups() == null) {
            return false;
        }
        if (other.backups() != null && !other.backups().equals(this.backups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backups() != null) {
            sb.append("Backups: ").append(this.backups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Backup> backups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsResponse model) {
            this.setBackups(model.backups);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Backup> getBackups() {
            return this.backups;
        }

        @Override
        public final Builder backups(Collection<Backup> backups) {
            this.backups = BackupsCopier.copy(backups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backups(Backup ... backups) {
            this.backups(Arrays.asList(backups));
            return this;
        }

        public final void setBackups(Collection<Backup> backups) {
            this.backups = BackupsCopier.copy(backups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeBackupsResponse build() {
            return new DescribeBackupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeBackupsResponse> {
        public Builder backups(Collection<Backup> var1);

        public Builder backups(Backup ... var1);

        public Builder nextToken(String var1);
    }
}

