/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworkscm.model.ServerEvent;
import software.amazon.awssdk.services.opsworkscm.model.ServerEventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final List<ServerEvent> serverEvents;
    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        this.serverEvents = builder.serverEvents;
        this.nextToken = builder.nextToken;
    }

    public List<ServerEvent> serverEvents() {
        return this.serverEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serverEvents() == null ? 0 : this.serverEvents().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        if (other.serverEvents() == null ^ this.serverEvents() == null) {
            return false;
        }
        if (other.serverEvents() != null && !other.serverEvents().equals(this.serverEvents())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serverEvents() != null) {
            sb.append("ServerEvents: ").append(this.serverEvents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ServerEvent> serverEvents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.setServerEvents(model.serverEvents);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ServerEvent> getServerEvents() {
            return this.serverEvents;
        }

        @Override
        public final Builder serverEvents(Collection<ServerEvent> serverEvents) {
            this.serverEvents = ServerEventsCopier.copy(serverEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverEvents(ServerEvent ... serverEvents) {
            this.serverEvents(Arrays.asList(serverEvents));
            return this;
        }

        public final void setServerEvents(Collection<ServerEvent> serverEvents) {
            this.serverEvents = ServerEventsCopier.copy(serverEvents);
        }

        @SafeVarargs
        public final void setServerEvents(ServerEvent ... serverEvents) {
            this.serverEvents(Arrays.asList(serverEvents));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder serverEvents(Collection<ServerEvent> var1);

        public Builder serverEvents(ServerEvent ... var1);

        public Builder nextToken(String var1);
    }
}

