/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworkscm.model.ServerEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServerEventMarshaller {
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUrl").isBinary(false).build();
    private static final ServerEventMarshaller INSTANCE = new ServerEventMarshaller();

    private ServerEventMarshaller() {
    }

    public static ServerEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServerEvent serverEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serverEvent, (String)"serverEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serverEvent.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)serverEvent.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)serverEvent.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)serverEvent.logUrl(), LOGURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

