/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworkscm.model.Server;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServerMarshaller {
    private static final MarshallingInfo<Boolean> ASSOCIATEPUBLICIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociatePublicIpAddress").isBinary(false).build();
    private static final MarshallingInfo<Integer> BACKUPRETENTIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupRetentionCount").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> CLOUDFORMATIONSTACKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudFormationStackArn").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DISABLEAUTOMATEDBACKUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisableAutomatedBackup").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Engine").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineModel").isBinary(false).build();
    private static final MarshallingInfo<List> ENGINEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> KEYPAIR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyPair").isBinary(false).build();
    private static final MarshallingInfo<String> MAINTENANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaintenanceStatus").isBinary(false).build();
    private static final MarshallingInfo<String> PREFERREDMAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredMaintenanceWindow").isBinary(false).build();
    private static final MarshallingInfo<String> PREFERREDBACKUPWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredBackupWindow").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusReason").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerArn").isBinary(false).build();
    private static final ServerMarshaller INSTANCE = new ServerMarshaller();

    private ServerMarshaller() {
    }

    public static ServerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Server server, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)server, (String)"server");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)server.associatePublicIpAddress(), ASSOCIATEPUBLICIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)server.backupRetentionCount(), BACKUPRETENTIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)server.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)server.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)server.cloudFormationStackArn(), CLOUDFORMATIONSTACKARN_BINDING);
            protocolMarshaller.marshall((Object)server.disableAutomatedBackup(), DISABLEAUTOMATEDBACKUP_BINDING);
            protocolMarshaller.marshall((Object)server.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)server.engine(), ENGINE_BINDING);
            protocolMarshaller.marshall((Object)server.engineModel(), ENGINEMODEL_BINDING);
            protocolMarshaller.marshall(server.engineAttributes(), ENGINEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)server.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)server.instanceProfileArn(), INSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)server.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)server.keyPair(), KEYPAIR_BINDING);
            protocolMarshaller.marshall((Object)server.maintenanceStatusAsString(), MAINTENANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)server.preferredMaintenanceWindow(), PREFERREDMAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)server.preferredBackupWindow(), PREFERREDBACKUPWINDOW_BINDING);
            protocolMarshaller.marshall(server.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)server.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)server.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)server.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall(server.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)server.serverArn(), SERVERARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

