/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DisassociateNodeRequestModelMarshaller {
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<String> NODENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeName").isBinary(false).build();
    private static final MarshallingInfo<List> ENGINEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineAttributes").isBinary(false).build();
    private static final DisassociateNodeRequestModelMarshaller INSTANCE = new DisassociateNodeRequestModelMarshaller();

    private DisassociateNodeRequestModelMarshaller() {
    }

    public static DisassociateNodeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DisassociateNodeRequest disassociateNodeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)disassociateNodeRequest), (String)"disassociateNodeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)disassociateNodeRequest.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)disassociateNodeRequest.nodeName(), NODENAME_BINDING);
            protocolMarshaller.marshall(disassociateNodeRequest.engineAttributes(), ENGINEATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

