/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNodeAssociationStatusResponse
extends OpsWorksCMResponse
implements ToCopyableBuilder<Builder, DescribeNodeAssociationStatusResponse> {
    private final String nodeAssociationStatus;
    private final List<EngineAttribute> engineAttributes;

    private DescribeNodeAssociationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nodeAssociationStatus = builder.nodeAssociationStatus;
        this.engineAttributes = builder.engineAttributes;
    }

    public NodeAssociationStatus nodeAssociationStatus() {
        return NodeAssociationStatus.fromValue(this.nodeAssociationStatus);
    }

    public String nodeAssociationStatusAsString() {
        return this.nodeAssociationStatus;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeAssociationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeAssociationStatusResponse)) {
            return false;
        }
        DescribeNodeAssociationStatusResponse other = (DescribeNodeAssociationStatusResponse)((Object)obj);
        return Objects.equals(this.nodeAssociationStatusAsString(), other.nodeAssociationStatusAsString()) && Objects.equals(this.engineAttributes(), other.engineAttributes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNodeAssociationStatusResponse").add("NodeAssociationStatus", (Object)this.nodeAssociationStatusAsString()).add("EngineAttributes", this.engineAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeAssociationStatus": {
                return Optional.of(clazz.cast(this.nodeAssociationStatusAsString()));
            }
            case "EngineAttributes": {
                return Optional.of(clazz.cast(this.engineAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMResponse.BuilderImpl
    implements Builder {
        private String nodeAssociationStatus;
        private List<EngineAttribute> engineAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeAssociationStatusResponse model) {
            super(model);
            this.nodeAssociationStatus(model.nodeAssociationStatus);
            this.engineAttributes(model.engineAttributes);
        }

        public final String getNodeAssociationStatus() {
            return this.nodeAssociationStatus;
        }

        @Override
        public final Builder nodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
            return this;
        }

        @Override
        public final Builder nodeAssociationStatus(NodeAssociationStatus nodeAssociationStatus) {
            this.nodeAssociationStatus(nodeAssociationStatus.toString());
            return this;
        }

        public final void setNodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder> ... engineAttributes) {
            this.engineAttributes(Stream.of(engineAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public DescribeNodeAssociationStatusResponse build() {
            return new DescribeNodeAssociationStatusResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMResponse.Builder,
    CopyableBuilder<Builder, DescribeNodeAssociationStatusResponse> {
        public Builder nodeAssociationStatus(String var1);

        public Builder nodeAssociationStatus(NodeAssociationStatus var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineAttributes(Consumer<EngineAttribute.Builder> ... var1);
    }
}

