/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBasedAutoScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoadBasedAutoScalingConfiguration.getter(LoadBasedAutoScalingConfiguration::layerId)).setter(LoadBasedAutoScalingConfiguration.setter(Builder::layerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()}).build();
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LoadBasedAutoScalingConfiguration.getter(LoadBasedAutoScalingConfiguration::enable)).setter(LoadBasedAutoScalingConfiguration.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enable").build()}).build();
    private static final SdkField<AutoScalingThresholds> UP_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LoadBasedAutoScalingConfiguration.getter(LoadBasedAutoScalingConfiguration::upScaling)).setter(LoadBasedAutoScalingConfiguration.setter(Builder::upScaling)).constructor(AutoScalingThresholds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpScaling").build()}).build();
    private static final SdkField<AutoScalingThresholds> DOWN_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LoadBasedAutoScalingConfiguration.getter(LoadBasedAutoScalingConfiguration::downScaling)).setter(LoadBasedAutoScalingConfiguration.setter(Builder::downScaling)).constructor(AutoScalingThresholds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownScaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD, ENABLE_FIELD, UP_SCALING_FIELD, DOWN_SCALING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String layerId;
    private final Boolean enable;
    private final AutoScalingThresholds upScaling;
    private final AutoScalingThresholds downScaling;

    private LoadBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    public String layerId() {
        return this.layerId;
    }

    public Boolean enable() {
        return this.enable;
    }

    public AutoScalingThresholds upScaling() {
        return this.upScaling;
    }

    public AutoScalingThresholds downScaling() {
        return this.downScaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.upScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.downScaling());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBasedAutoScalingConfiguration)) {
            return false;
        }
        LoadBasedAutoScalingConfiguration other = (LoadBasedAutoScalingConfiguration)obj;
        return Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.enable(), other.enable()) && Objects.equals(this.upScaling(), other.upScaling()) && Objects.equals(this.downScaling(), other.downScaling());
    }

    public String toString() {
        return ToString.builder((String)"LoadBasedAutoScalingConfiguration").add("LayerId", (Object)this.layerId()).add("Enable", (Object)this.enable()).add("UpScaling", (Object)this.upScaling()).add("DownScaling", (Object)this.downScaling()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerId": {
                return Optional.ofNullable(clazz.cast(this.layerId()));
            }
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
            case "UpScaling": {
                return Optional.ofNullable(clazz.cast(this.upScaling()));
            }
            case "DownScaling": {
                return Optional.ofNullable(clazz.cast(this.downScaling()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBasedAutoScalingConfiguration, T> g) {
        return obj -> g.apply((LoadBasedAutoScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerId;
        private Boolean enable;
        private AutoScalingThresholds upScaling;
        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBasedAutoScalingConfiguration model) {
            this.layerId(model.layerId);
            this.enable(model.enable);
            this.upScaling(model.upScaling);
            this.downScaling(model.downScaling);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds.Builder getUpScaling() {
            return this.upScaling != null ? this.upScaling.toBuilder() : null;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds.BuilderImpl upScaling) {
            this.upScaling = upScaling != null ? upScaling.build() : null;
        }

        public final AutoScalingThresholds.Builder getDownScaling() {
            return this.downScaling != null ? this.downScaling.toBuilder() : null;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds.BuilderImpl downScaling) {
            this.downScaling = downScaling != null ? downScaling.build() : null;
        }

        public LoadBasedAutoScalingConfiguration build() {
            return new LoadBasedAutoScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
        public Builder layerId(String var1);

        public Builder enable(Boolean var1);

        public Builder upScaling(AutoScalingThresholds var1);

        default public Builder upScaling(Consumer<AutoScalingThresholds.Builder> upScaling) {
            return this.upScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().applyMutation(upScaling)).build());
        }

        public Builder downScaling(AutoScalingThresholds var1);

        default public Builder downScaling(Consumer<AutoScalingThresholds.Builder> downScaling) {
            return this.downScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().applyMutation(downScaling)).build());
        }
    }
}

