/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::volumeId)).setter(Volume.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> EC2_VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::ec2VolumeId)).setter(Volume.setter(Builder::ec2VolumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2VolumeId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::name)).setter(Volume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RAID_ARRAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::raidArrayId)).setter(Volume.setter(Builder::raidArrayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrayId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::instanceId)).setter(Volume.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::status)).setter(Volume.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Volume.getter(Volume::size)).setter(Volume.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::device)).setter(Volume.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()}).build();
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::mountPoint)).setter(Volume.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::region)).setter(Volume.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::availabilityZone)).setter(Volume.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Volume.getter(Volume::volumeType)).setter(Volume.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Volume.getter(Volume::iops)).setter(Volume.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Volume.getter(Volume::encrypted)).setter(Volume.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, EC2_VOLUME_ID_FIELD, NAME_FIELD, RAID_ARRAY_ID_FIELD, INSTANCE_ID_FIELD, STATUS_FIELD, SIZE_FIELD, DEVICE_FIELD, MOUNT_POINT_FIELD, REGION_FIELD, AVAILABILITY_ZONE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String volumeId;
    private final String ec2VolumeId;
    private final String name;
    private final String raidArrayId;
    private final String instanceId;
    private final String status;
    private final Integer size;
    private final String device;
    private final String mountPoint;
    private final String region;
    private final String availabilityZone;
    private final String volumeType;
    private final Integer iops;
    private final Boolean encrypted;

    private Volume(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.ec2VolumeId = builder.ec2VolumeId;
        this.name = builder.name;
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public String ec2VolumeId() {
        return this.ec2VolumeId;
    }

    public String name() {
        return this.name;
    }

    public String raidArrayId() {
        return this.raidArrayId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String status() {
        return this.status;
    }

    public Integer size() {
        return this.size;
    }

    public String device() {
        return this.device;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public String region() {
        return this.region;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2VolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidArrayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.ec2VolumeId(), other.ec2VolumeId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.raidArrayId(), other.raidArrayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.encrypted(), other.encrypted());
    }

    public String toString() {
        return ToString.builder((String)"Volume").add("VolumeId", (Object)this.volumeId()).add("Ec2VolumeId", (Object)this.ec2VolumeId()).add("Name", (Object)this.name()).add("RaidArrayId", (Object)this.raidArrayId()).add("InstanceId", (Object)this.instanceId()).add("Status", (Object)this.status()).add("Size", (Object)this.size()).add("Device", (Object)this.device()).add("MountPoint", (Object)this.mountPoint()).add("Region", (Object)this.region()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).add("Encrypted", (Object)this.encrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Ec2VolumeId": {
                return Optional.ofNullable(clazz.cast(this.ec2VolumeId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RaidArrayId": {
                return Optional.ofNullable(clazz.cast(this.raidArrayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "MountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private String ec2VolumeId;
        private String name;
        private String raidArrayId;
        private String instanceId;
        private String status;
        private Integer size;
        private String device;
        private String mountPoint;
        private String region;
        private String availabilityZone;
        private String volumeType;
        private Integer iops;
        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.volumeId(model.volumeId);
            this.ec2VolumeId(model.ec2VolumeId);
            this.name(model.name);
            this.raidArrayId(model.raidArrayId);
            this.instanceId(model.instanceId);
            this.status(model.status);
            this.size(model.size);
            this.device(model.device);
            this.mountPoint(model.mountPoint);
            this.region(model.region);
            this.availabilityZone(model.availabilityZone);
            this.volumeType(model.volumeType);
            this.iops(model.iops);
            this.encrypted(model.encrypted);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getEc2VolumeId() {
            return this.ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRaidArrayId() {
            return this.raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder volumeId(String var1);

        public Builder ec2VolumeId(String var1);

        public Builder name(String var1);

        public Builder raidArrayId(String var1);

        public Builder instanceId(String var1);

        public Builder status(String var1);

        public Builder size(Integer var1);

        public Builder device(String var1);

        public Builder mountPoint(String var1);

        public Builder region(String var1);

        public Builder availabilityZone(String var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder encrypted(Boolean var1);
    }
}

