/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;
import software.amazon.awssdk.services.opsworks.model.EcsClustersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEcsClustersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeEcsClustersResponse> {
    private static final SdkField<List<EcsCluster>> ECS_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EcsClusters").getter(DescribeEcsClustersResponse.getter(DescribeEcsClustersResponse::ecsClusters)).setter(DescribeEcsClustersResponse.setter(Builder::ecsClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEcsClustersResponse.getter(DescribeEcsClustersResponse::nextToken)).setter(DescribeEcsClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECS_CLUSTERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EcsCluster> ecsClusters;
    private final String nextToken;

    private DescribeEcsClustersResponse(BuilderImpl builder) {
        super(builder);
        this.ecsClusters = builder.ecsClusters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEcsClusters() {
        return this.ecsClusters != null && !(this.ecsClusters instanceof SdkAutoConstructList);
    }

    public final List<EcsCluster> ecsClusters() {
        return this.ecsClusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcsClusters() ? this.ecsClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersResponse)) {
            return false;
        }
        DescribeEcsClustersResponse other = (DescribeEcsClustersResponse)((Object)obj);
        return this.hasEcsClusters() == other.hasEcsClusters() && Objects.equals(this.ecsClusters(), other.ecsClusters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEcsClustersResponse").add("EcsClusters", this.hasEcsClusters() ? this.ecsClusters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusters": {
                return Optional.ofNullable(clazz.cast(this.ecsClusters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEcsClustersResponse, T> g) {
        return obj -> g.apply((DescribeEcsClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<EcsCluster> ecsClusters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersResponse model) {
            super(model);
            this.ecsClusters(model.ecsClusters);
            this.nextToken(model.nextToken);
        }

        public final List<EcsCluster.Builder> getEcsClusters() {
            List<EcsCluster.Builder> result = EcsClustersCopier.copyToBuilder(this.ecsClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcsClusters(Collection<EcsCluster.BuilderImpl> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copyFromBuilder(ecsClusters);
        }

        @Override
        public final Builder ecsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(EcsCluster ... ecsClusters) {
            this.ecsClusters(Arrays.asList(ecsClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(Consumer<EcsCluster.Builder> ... ecsClusters) {
            this.ecsClusters(Stream.of(ecsClusters).map(c -> (EcsCluster)((EcsCluster.Builder)EcsCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEcsClustersResponse build() {
            return new DescribeEcsClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEcsClustersResponse> {
        public Builder ecsClusters(Collection<EcsCluster> var1);

        public Builder ecsClusters(EcsCluster ... var1);

        public Builder ecsClusters(Consumer<EcsCluster.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

