/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Command implements SdkPojo, Serializable, ToCopyableBuilder<Command.Builder, Command> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommandId").getter(getter(Command::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(Command::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(Command::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(Command::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> ACKNOWLEDGED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcknowledgedAt").getter(getter(Command::acknowledgedAt)).setter(setter(Builder::acknowledgedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedAt").build()).build();

    private static final SdkField<String> COMPLETED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompletedAt").getter(getter(Command::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Command::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExitCode").getter(getter(Command::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitCode").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LogUrl")
            .getter(getter(Command::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUrl").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Command::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            INSTANCE_ID_FIELD, DEPLOYMENT_ID_FIELD, CREATED_AT_FIELD, ACKNOWLEDGED_AT_FIELD, COMPLETED_AT_FIELD, STATUS_FIELD,
            EXIT_CODE_FIELD, LOG_URL_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commandId;

    private final String instanceId;

    private final String deploymentId;

    private final String createdAt;

    private final String acknowledgedAt;

    private final String completedAt;

    private final String status;

    private final Integer exitCode;

    private final String logUrl;

    private final String type;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.deploymentId = builder.deploymentId;
        this.createdAt = builder.createdAt;
        this.acknowledgedAt = builder.acknowledgedAt;
        this.completedAt = builder.completedAt;
        this.status = builder.status;
        this.exitCode = builder.exitCode;
        this.logUrl = builder.logUrl;
        this.type = builder.type;
    }

    /**
     * <p>
     * The command ID.
     * </p>
     * 
     * @return The command ID.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The ID of the instance where the command was executed.
     * </p>
     * 
     * @return The ID of the instance where the command was executed.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The command deployment ID.
     * </p>
     * 
     * @return The command deployment ID.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Date and time when the command was run.
     * </p>
     * 
     * @return Date and time when the command was run.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date and time when the command was acknowledged.
     * </p>
     * 
     * @return Date and time when the command was acknowledged.
     */
    public final String acknowledgedAt() {
        return acknowledgedAt;
    }

    /**
     * <p>
     * Date when the command completed.
     * </p>
     * 
     * @return Date when the command completed.
     */
    public final String completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The command status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * failed
     * </p>
     * </li>
     * <li>
     * <p>
     * successful
     * </p>
     * </li>
     * <li>
     * <p>
     * skipped
     * </p>
     * </li>
     * <li>
     * <p>
     * pending
     * </p>
     * </li>
     * </ul>
     * 
     * @return The command status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         failed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         successful
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         skipped
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pending
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The command exit code.
     * </p>
     * 
     * @return The command exit code.
     */
    public final Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * The URL of the command log.
     * </p>
     * 
     * @return The URL of the command log.
     */
    public final String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * The command type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>configure</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>execute_recipes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>install_dependencies</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>restart</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rollback</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>setup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undeploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_custom_cookbooks</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_dependencies</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The command type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>configure</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>execute_recipes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>install_dependencies</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>restart</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rollback</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>setup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undeploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_custom_cookbooks</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_dependencies</code>
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(acknowledgedAt(), other.acknowledgedAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(status(), other.status()) && Objects.equals(exitCode(), other.exitCode())
                && Objects.equals(logUrl(), other.logUrl()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Command").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("DeploymentId", deploymentId()).add("CreatedAt", createdAt()).add("AcknowledgedAt", acknowledgedAt())
                .add("CompletedAt", completedAt()).add("Status", status()).add("ExitCode", exitCode()).add("LogUrl", logUrl())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "AcknowledgedAt":
            return Optional.ofNullable(clazz.cast(acknowledgedAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ExitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "LogUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Command> {
        /**
         * <p>
         * The command ID.
         * </p>
         * 
         * @param commandId
         *        The command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The ID of the instance where the command was executed.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance where the command was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The command deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The command deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Date and time when the command was run.
         * </p>
         * 
         * @param createdAt
         *        Date and time when the command was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Date and time when the command was acknowledged.
         * </p>
         * 
         * @param acknowledgedAt
         *        Date and time when the command was acknowledged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedAt(String acknowledgedAt);

        /**
         * <p>
         * Date when the command completed.
         * </p>
         * 
         * @param completedAt
         *        Date when the command completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(String completedAt);

        /**
         * <p>
         * The command status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * failed
         * </p>
         * </li>
         * <li>
         * <p>
         * successful
         * </p>
         * </li>
         * <li>
         * <p>
         * skipped
         * </p>
         * </li>
         * <li>
         * <p>
         * pending
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The command status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        failed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        successful
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        skipped
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pending
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The command exit code.
         * </p>
         * 
         * @param exitCode
         *        The command exit code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * The URL of the command log.
         * </p>
         * 
         * @param logUrl
         *        The URL of the command log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * The command type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>configure</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>execute_recipes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>setup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The command type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>configure</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>setup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String deploymentId;

        private String createdAt;

        private String acknowledgedAt;

        private String completedAt;

        private String status;

        private Integer exitCode;

        private String logUrl;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            commandId(model.commandId);
            instanceId(model.instanceId);
            deploymentId(model.deploymentId);
            createdAt(model.createdAt);
            acknowledgedAt(model.acknowledgedAt);
            completedAt(model.completedAt);
            status(model.status);
            exitCode(model.exitCode);
            logUrl(model.logUrl);
            type(model.type);
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAcknowledgedAt() {
            return acknowledgedAt;
        }

        public final void setAcknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
        }

        @Override
        public final Builder acknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
            return this;
        }

        public final String getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Command build() {
            return new Command(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
