/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OperatingSystemConfigurationManager;
import software.amazon.awssdk.services.opsworks.model.OperatingSystemConfigurationManagersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OperatingSystem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OperatingSystem> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OperatingSystem.getter(OperatingSystem::name)).setter(OperatingSystem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OperatingSystem.getter(OperatingSystem::id)).setter(OperatingSystem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OperatingSystem.getter(OperatingSystem::type)).setter(OperatingSystem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<OperatingSystemConfigurationManager>> CONFIGURATION_MANAGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationManagers").getter(OperatingSystem.getter(OperatingSystem::configurationManagers)).setter(OperatingSystem.setter(Builder::configurationManagers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManagers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperatingSystemConfigurationManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPORTED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportedName").getter(OperatingSystem.getter(OperatingSystem::reportedName)).setter(OperatingSystem.setter(Builder::reportedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedName").build()}).build();
    private static final SdkField<String> REPORTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportedVersion").getter(OperatingSystem.getter(OperatingSystem::reportedVersion)).setter(OperatingSystem.setter(Builder::reportedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedVersion").build()}).build();
    private static final SdkField<Boolean> SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Supported").getter(OperatingSystem.getter(OperatingSystem::supported)).setter(OperatingSystem.setter(Builder::supported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Supported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, TYPE_FIELD, CONFIGURATION_MANAGERS_FIELD, REPORTED_NAME_FIELD, REPORTED_VERSION_FIELD, SUPPORTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String type;
    private final List<OperatingSystemConfigurationManager> configurationManagers;
    private final String reportedName;
    private final String reportedVersion;
    private final Boolean supported;

    private OperatingSystem(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.type = builder.type;
        this.configurationManagers = builder.configurationManagers;
        this.reportedName = builder.reportedName;
        this.reportedVersion = builder.reportedVersion;
        this.supported = builder.supported;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasConfigurationManagers() {
        return this.configurationManagers != null && !(this.configurationManagers instanceof SdkAutoConstructList);
    }

    public final List<OperatingSystemConfigurationManager> configurationManagers() {
        return this.configurationManagers;
    }

    public final String reportedName() {
        return this.reportedName;
    }

    public final String reportedVersion() {
        return this.reportedVersion;
    }

    public final Boolean supported() {
        return this.supported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationManagers() ? this.configurationManagers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supported());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && this.hasConfigurationManagers() == other.hasConfigurationManagers() && Objects.equals(this.configurationManagers(), other.configurationManagers()) && Objects.equals(this.reportedName(), other.reportedName()) && Objects.equals(this.reportedVersion(), other.reportedVersion()) && Objects.equals(this.supported(), other.supported());
    }

    public final String toString() {
        return ToString.builder((String)"OperatingSystem").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("ConfigurationManagers", this.hasConfigurationManagers() ? this.configurationManagers() : null).add("ReportedName", (Object)this.reportedName()).add("ReportedVersion", (Object)this.reportedVersion()).add("Supported", (Object)this.supported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ConfigurationManagers": {
                return Optional.ofNullable(clazz.cast(this.configurationManagers()));
            }
            case "ReportedName": {
                return Optional.ofNullable(clazz.cast(this.reportedName()));
            }
            case "ReportedVersion": {
                return Optional.ofNullable(clazz.cast(this.reportedVersion()));
            }
            case "Supported": {
                return Optional.ofNullable(clazz.cast(this.supported()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperatingSystem, T> g) {
        return obj -> g.apply((OperatingSystem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String type;
        private List<OperatingSystemConfigurationManager> configurationManagers = DefaultSdkAutoConstructList.getInstance();
        private String reportedName;
        private String reportedVersion;
        private Boolean supported;

        private BuilderImpl() {
        }

        private BuilderImpl(OperatingSystem model) {
            this.name(model.name);
            this.id(model.id);
            this.type(model.type);
            this.configurationManagers(model.configurationManagers);
            this.reportedName(model.reportedName);
            this.reportedVersion(model.reportedVersion);
            this.supported(model.supported);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final List<OperatingSystemConfigurationManager.Builder> getConfigurationManagers() {
            List<OperatingSystemConfigurationManager.Builder> result = OperatingSystemConfigurationManagersCopier.copyToBuilder(this.configurationManagers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copy(configurationManagers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(OperatingSystemConfigurationManager ... configurationManagers) {
            this.configurationManagers(Arrays.asList(configurationManagers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder> ... configurationManagers) {
            this.configurationManagers(Stream.of(configurationManagers).map(c -> (OperatingSystemConfigurationManager)((OperatingSystemConfigurationManager.Builder)OperatingSystemConfigurationManager.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationManagers(Collection<OperatingSystemConfigurationManager.BuilderImpl> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copyFromBuilder(configurationManagers);
        }

        public final String getReportedName() {
            return this.reportedName;
        }

        @Override
        public final Builder reportedName(String reportedName) {
            this.reportedName = reportedName;
            return this;
        }

        public final void setReportedName(String reportedName) {
            this.reportedName = reportedName;
        }

        public final String getReportedVersion() {
            return this.reportedVersion;
        }

        @Override
        public final Builder reportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
            return this;
        }

        public final void setReportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
        }

        public final Boolean getSupported() {
            return this.supported;
        }

        @Override
        public final Builder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public final void setSupported(Boolean supported) {
            this.supported = supported;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OperatingSystem> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder configurationManagers(Collection<OperatingSystemConfigurationManager> var1);

        public Builder configurationManagers(OperatingSystemConfigurationManager ... var1);

        public Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder> ... var1);

        public Builder reportedName(String var1);

        public Builder reportedVersion(String var1);

        public Builder supported(Boolean var1);
    }
}

