/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.InstanceIdentity;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, RegisterInstanceRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::stackId)).setter(RegisterInstanceRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hostname").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::hostname)).setter(RegisterInstanceRequest.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::publicIp)).setter(RegisterInstanceRequest.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").build()}).build();
    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIp").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::privateIp)).setter(RegisterInstanceRequest.setter(Builder::privateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp").build()}).build();
    private static final SdkField<String> RSA_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RsaPublicKey").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::rsaPublicKey)).setter(RegisterInstanceRequest.setter(Builder::rsaPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RsaPublicKey").build()}).build();
    private static final SdkField<String> RSA_PUBLIC_KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RsaPublicKeyFingerprint").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::rsaPublicKeyFingerprint)).setter(RegisterInstanceRequest.setter(Builder::rsaPublicKeyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RsaPublicKeyFingerprint").build()}).build();
    private static final SdkField<InstanceIdentity> INSTANCE_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceIdentity").getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::instanceIdentity)).setter(RegisterInstanceRequest.setter(Builder::instanceIdentity)).constructor(InstanceIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, HOSTNAME_FIELD, PUBLIC_IP_FIELD, PRIVATE_IP_FIELD, RSA_PUBLIC_KEY_FIELD, RSA_PUBLIC_KEY_FINGERPRINT_FIELD, INSTANCE_IDENTITY_FIELD));
    private final String stackId;
    private final String hostname;
    private final String publicIp;
    private final String privateIp;
    private final String rsaPublicKey;
    private final String rsaPublicKeyFingerprint;
    private final InstanceIdentity instanceIdentity;

    private RegisterInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.hostname = builder.hostname;
        this.publicIp = builder.publicIp;
        this.privateIp = builder.privateIp;
        this.rsaPublicKey = builder.rsaPublicKey;
        this.rsaPublicKeyFingerprint = builder.rsaPublicKeyFingerprint;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String privateIp() {
        return this.privateIp;
    }

    public final String rsaPublicKey() {
        return this.rsaPublicKey;
    }

    public final String rsaPublicKeyFingerprint() {
        return this.rsaPublicKeyFingerprint;
    }

    public final InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsaPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsaPublicKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.rsaPublicKey(), other.rsaPublicKey()) && Objects.equals(this.rsaPublicKeyFingerprint(), other.rsaPublicKeyFingerprint()) && Objects.equals(this.instanceIdentity(), other.instanceIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterInstanceRequest").add("StackId", (Object)this.stackId()).add("Hostname", (Object)this.hostname()).add("PublicIp", (Object)this.publicIp()).add("PrivateIp", (Object)this.privateIp()).add("RsaPublicKey", (Object)this.rsaPublicKey()).add("RsaPublicKeyFingerprint", (Object)this.rsaPublicKeyFingerprint()).add("InstanceIdentity", (Object)this.instanceIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "PrivateIp": {
                return Optional.ofNullable(clazz.cast(this.privateIp()));
            }
            case "RsaPublicKey": {
                return Optional.ofNullable(clazz.cast(this.rsaPublicKey()));
            }
            case "RsaPublicKeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.rsaPublicKeyFingerprint()));
            }
            case "InstanceIdentity": {
                return Optional.ofNullable(clazz.cast(this.instanceIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterInstanceRequest, T> g) {
        return obj -> g.apply((RegisterInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String hostname;
        private String publicIp;
        private String privateIp;
        private String rsaPublicKey;
        private String rsaPublicKeyFingerprint;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.hostname(model.hostname);
            this.publicIp(model.publicIp);
            this.privateIp(model.privateIp);
            this.rsaPublicKey(model.rsaPublicKey);
            this.rsaPublicKeyFingerprint(model.rsaPublicKeyFingerprint);
            this.instanceIdentity(model.instanceIdentity);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getRsaPublicKey() {
            return this.rsaPublicKey;
        }

        @Override
        public final Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public final void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public final String getRsaPublicKeyFingerprint() {
            return this.rsaPublicKeyFingerprint;
        }

        @Override
        public final Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
            return this;
        }

        public final void setRsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return this.instanceIdentity != null ? this.instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterInstanceRequest> {
        public Builder stackId(String var1);

        public Builder hostname(String var1);

        public Builder publicIp(String var1);

        public Builder privateIp(String var1);

        public Builder rsaPublicKey(String var1);

        public Builder rsaPublicKeyFingerprint(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);

        default public Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return this.instanceIdentity((InstanceIdentity)((InstanceIdentity.Builder)InstanceIdentity.builder().applyMutation(instanceIdentity)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

