/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DeleteInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DeleteInstanceRequest.getter(DeleteInstanceRequest::instanceId)).setter(DeleteInstanceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Boolean> DELETE_ELASTIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteElasticIp").getter(DeleteInstanceRequest.getter(DeleteInstanceRequest::deleteElasticIp)).setter(DeleteInstanceRequest.setter(Builder::deleteElasticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteElasticIp").build()}).build();
    private static final SdkField<Boolean> DELETE_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteVolumes").getter(DeleteInstanceRequest.getter(DeleteInstanceRequest::deleteVolumes)).setter(DeleteInstanceRequest.setter(Builder::deleteVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteVolumes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DELETE_ELASTIC_IP_FIELD, DELETE_VOLUMES_FIELD));
    private final String instanceId;
    private final Boolean deleteElasticIp;
    private final Boolean deleteVolumes;

    private DeleteInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.deleteElasticIp = builder.deleteElasticIp;
        this.deleteVolumes = builder.deleteVolumes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Boolean deleteElasticIp() {
        return this.deleteElasticIp;
    }

    public final Boolean deleteVolumes() {
        return this.deleteVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteElasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteVolumes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.deleteElasticIp(), other.deleteElasticIp()) && Objects.equals(this.deleteVolumes(), other.deleteVolumes());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInstanceRequest").add("InstanceId", (Object)this.instanceId()).add("DeleteElasticIp", (Object)this.deleteElasticIp()).add("DeleteVolumes", (Object)this.deleteVolumes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DeleteElasticIp": {
                return Optional.ofNullable(clazz.cast(this.deleteElasticIp()));
            }
            case "DeleteVolumes": {
                return Optional.ofNullable(clazz.cast(this.deleteVolumes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceRequest, T> g) {
        return obj -> g.apply((DeleteInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean deleteElasticIp;
        private Boolean deleteVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.deleteElasticIp(model.deleteElasticIp);
            this.deleteVolumes(model.deleteVolumes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getDeleteElasticIp() {
            return this.deleteElasticIp;
        }

        @Override
        public final Builder deleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
            return this;
        }

        public final void setDeleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
        }

        public final Boolean getDeleteVolumes() {
            return this.deleteVolumes;
        }

        @Override
        public final Builder deleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
            return this;
        }

        public final void setDeleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder deleteElasticIp(Boolean var1);

        public Builder deleteVolumes(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

