/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.LoadBasedAutoScalingConfiguration;
import software.amazon.awssdk.services.opsworks.model.LoadBasedAutoScalingConfigurationsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBasedAutoScalingResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeLoadBasedAutoScalingResponse> {
    private static final SdkField<List<LoadBasedAutoScalingConfiguration>> LOAD_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBasedAutoScalingConfigurations").getter(DescribeLoadBasedAutoScalingResponse.getter(DescribeLoadBasedAutoScalingResponse::loadBasedAutoScalingConfigurations)).setter(DescribeLoadBasedAutoScalingResponse.setter(Builder::loadBasedAutoScalingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBasedAutoScalingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBasedAutoScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD));
    private final List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations;

    private DescribeLoadBasedAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.loadBasedAutoScalingConfigurations = builder.loadBasedAutoScalingConfigurations;
    }

    public boolean hasLoadBasedAutoScalingConfigurations() {
        return this.loadBasedAutoScalingConfigurations != null && !(this.loadBasedAutoScalingConfigurations instanceof SdkAutoConstructList);
    }

    public List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations() {
        return this.loadBasedAutoScalingConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBasedAutoScalingConfigurations() ? this.loadBasedAutoScalingConfigurations() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBasedAutoScalingResponse)) {
            return false;
        }
        DescribeLoadBasedAutoScalingResponse other = (DescribeLoadBasedAutoScalingResponse)((Object)obj);
        return this.hasLoadBasedAutoScalingConfigurations() == other.hasLoadBasedAutoScalingConfigurations() && Objects.equals(this.loadBasedAutoScalingConfigurations(), other.loadBasedAutoScalingConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBasedAutoScalingResponse").add("LoadBasedAutoScalingConfigurations", this.hasLoadBasedAutoScalingConfigurations() ? this.loadBasedAutoScalingConfigurations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBasedAutoScalingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.loadBasedAutoScalingConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBasedAutoScalingResponse, T> g) {
        return obj -> g.apply((DescribeLoadBasedAutoScalingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBasedAutoScalingResponse model) {
            super(model);
            this.loadBasedAutoScalingConfigurations(model.loadBasedAutoScalingConfigurations);
        }

        public final Collection<LoadBasedAutoScalingConfiguration.Builder> getLoadBasedAutoScalingConfigurations() {
            if (this.loadBasedAutoScalingConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBasedAutoScalingConfigurations != null ? (Collection)this.loadBasedAutoScalingConfigurations.stream().map(LoadBasedAutoScalingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBasedAutoScalingConfigurations(Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier.copy(loadBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(LoadBasedAutoScalingConfiguration ... loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations(Arrays.asList(loadBasedAutoScalingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(Consumer<LoadBasedAutoScalingConfiguration.Builder> ... loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations(Stream.of(loadBasedAutoScalingConfigurations).map(c -> (LoadBasedAutoScalingConfiguration)((LoadBasedAutoScalingConfiguration.Builder)LoadBasedAutoScalingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBasedAutoScalingConfigurations(Collection<LoadBasedAutoScalingConfiguration.BuilderImpl> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier.copyFromBuilder(loadBasedAutoScalingConfigurations);
        }

        @Override
        public DescribeLoadBasedAutoScalingResponse build() {
            return new DescribeLoadBasedAutoScalingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBasedAutoScalingResponse> {
        public Builder loadBasedAutoScalingConfigurations(Collection<LoadBasedAutoScalingConfiguration> var1);

        public Builder loadBasedAutoScalingConfigurations(LoadBasedAutoScalingConfiguration ... var1);

        public Builder loadBasedAutoScalingConfigurations(Consumer<LoadBasedAutoScalingConfiguration.Builder> ... var1);
    }
}

