/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommandArgsCopier;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommandName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentCommand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentCommand.getter(DeploymentCommand::nameAsString)).setter(DeploymentCommand.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, List<String>>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DeploymentCommand.getter(DeploymentCommand::args)).setter(DeploymentCommand.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, List<String>> args;

    private DeploymentCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    public DeploymentCommandName name() {
        return DeploymentCommandName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public Map<String, List<String>> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCommand)) {
            return false;
        }
        DeploymentCommand other = (DeploymentCommand)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentCommand").add("Name", (Object)this.nameAsString()).add("Args", this.args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentCommand, T> g) {
        return obj -> g.apply((DeploymentCommand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, List<String>> args = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentCommand model) {
            this.name(model.name);
            this.args(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DeploymentCommandName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, ? extends Collection<String>> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
            return this;
        }

        public final void setArgs(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
        }

        public DeploymentCommand build() {
            return new DeploymentCommand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentCommand> {
        public Builder name(String var1);

        public Builder name(DeploymentCommandName var1);

        public Builder args(Map<String, ? extends Collection<String>> var1);
    }
}

