/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.DescribeVolumesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeVolumesRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> RAIDARRAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidArrayId").isBinary(false).build();
    private static final MarshallingInfo<List> VOLUMEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeIds").isBinary(false).build();
    private static final DescribeVolumesRequestModelMarshaller INSTANCE = new DescribeVolumesRequestModelMarshaller();

    private DescribeVolumesRequestModelMarshaller() {
    }

    public static DescribeVolumesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeVolumesRequest describeVolumesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeVolumesRequest), (String)"describeVolumesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeVolumesRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)describeVolumesRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)describeVolumesRequest.raidArrayId(), RAIDARRAYID_BINDING);
            protocolMarshaller.marshall(describeVolumesRequest.volumeIds(), VOLUMEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

