/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CreateUserProfileRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateUserProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").isBinary(false).build();
    private static final MarshallingInfo<String> SSHUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshUsername").isBinary(false).build();
    private static final MarshallingInfo<String> SSHPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshPublicKey").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWSELFMANAGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSelfManagement").isBinary(false).build();
    private static final CreateUserProfileRequestModelMarshaller INSTANCE = new CreateUserProfileRequestModelMarshaller();

    private CreateUserProfileRequestModelMarshaller() {
    }

    public static CreateUserProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserProfileRequest createUserProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createUserProfileRequest), (String)"createUserProfileRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createUserProfileRequest.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)createUserProfileRequest.sshUsername(), SSHUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserProfileRequest.sshPublicKey(), SSHPUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)createUserProfileRequest.allowSelfManagement(), ALLOWSELFMANAGEMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

