/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.VolumeConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private final String mountPoint;
    private final Integer raidLevel;
    private final Integer numberOfDisks;
    private final Integer size;
    private final String volumeType;
    private final Integer iops;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public Integer raidLevel() {
        return this.raidLevel;
    }

    public Integer numberOfDisks() {
        return this.numberOfDisks;
    }

    public Integer size() {
        return this.size;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        return Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.raidLevel(), other.raidLevel()) && Objects.equals(this.numberOfDisks(), other.numberOfDisks()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops());
    }

    public String toString() {
        return ToString.builder((String)"VolumeConfiguration").add("MountPoint", (Object)this.mountPoint()).add("RaidLevel", (Object)this.raidLevel()).add("NumberOfDisks", (Object)this.numberOfDisks()).add("Size", (Object)this.size()).add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountPoint": {
                return Optional.of(clazz.cast(this.mountPoint()));
            }
            case "RaidLevel": {
                return Optional.of(clazz.cast(this.raidLevel()));
            }
            case "NumberOfDisks": {
                return Optional.of(clazz.cast(this.numberOfDisks()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String mountPoint;
        private Integer raidLevel;
        private Integer numberOfDisks;
        private Integer size;
        private String volumeType;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.mountPoint(model.mountPoint);
            this.raidLevel(model.raidLevel);
            this.numberOfDisks(model.numberOfDisks);
            this.size(model.size);
            this.volumeType(model.volumeType);
            this.iops(model.iops);
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final Integer getRaidLevel() {
            return this.raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return this.numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder mountPoint(String var1);

        public Builder raidLevel(Integer var1);

        public Builder numberOfDisks(Integer var1);

        public Builder size(Integer var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);
    }
}

