/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePermissionsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribePermissionsRequest> {
    private final String iamUserArn;
    private final String stackId;

    private DescribePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
        this.stackId = builder.stackId;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String stackId() {
        return this.stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsRequest)) {
            return false;
        }
        DescribePermissionsRequest other = (DescribePermissionsRequest)((Object)obj);
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.stackId(), other.stackId());
    }

    public String toString() {
        return ToString.builder((String)"DescribePermissionsRequest").add("IamUserArn", (Object)this.iamUserArn()).add("StackId", (Object)this.stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsRequest model) {
            this.iamUserArn(model.iamUserArn);
            this.stackId(model.stackId);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePermissionsRequest build() {
            return new DescribePermissionsRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribePermissionsRequest> {
        public Builder iamUserArn(String var1);

        public Builder stackId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

