/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.opsworks.model.AppAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.AppAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.AppType;
import software.amazon.awssdk.services.opsworks.model.DataSource;
import software.amazon.awssdk.services.opsworks.model.DataSourcesCopier;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariable;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.SslConfiguration;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAppRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAppRequest> {
    private final String appId;
    private final String name;
    private final String description;
    private final List<DataSource> dataSources;
    private final String type;
    private final Source appSource;
    private final List<String> domains;
    private final Boolean enableSsl;
    private final SslConfiguration sslConfiguration;
    private final Map<String, String> attributes;
    private final List<EnvironmentVariable> environment;

    private UpdateAppRequest(BuilderImpl builder) {
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    public String appId() {
        return this.appId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<DataSource> dataSources() {
        return this.dataSources;
    }

    public AppType type() {
        return AppType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Source appSource() {
        return this.appSource;
    }

    public List<String> domains() {
        return this.domains;
    }

    public Boolean enableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    public Map<AppAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, AppAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)AppAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesStrings() {
        return this.attributes;
    }

    public List<EnvironmentVariable> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.domains());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSsl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.appSource(), other.appSource()) && Objects.equals(this.domains(), other.domains()) && Objects.equals(this.enableSsl(), other.enableSsl()) && Objects.equals(this.sslConfiguration(), other.sslConfiguration()) && Objects.equals(this.attributesStrings(), other.attributesStrings()) && Objects.equals(this.environment(), other.environment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.appId() != null) {
            sb.append("AppId: ").append(this.appId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.dataSources() != null) {
            sb.append("DataSources: ").append(this.dataSources()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.appSource() != null) {
            sb.append("AppSource: ").append(this.appSource()).append(",");
        }
        if (this.domains() != null) {
            sb.append("Domains: ").append(this.domains()).append(",");
        }
        if (this.enableSsl() != null) {
            sb.append("EnableSsl: ").append(this.enableSsl()).append(",");
        }
        if (this.sslConfiguration() != null) {
            sb.append("SslConfiguration: ").append(this.sslConfiguration()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.of(clazz.cast(this.appId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DataSources": {
                return Optional.of(clazz.cast(this.dataSources()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "AppSource": {
                return Optional.of(clazz.cast(this.appSource()));
            }
            case "Domains": {
                return Optional.of(clazz.cast(this.domains()));
            }
            case "EnableSsl": {
                return Optional.of(clazz.cast(this.enableSsl()));
            }
            case "SslConfiguration": {
                return Optional.of(clazz.cast(this.sslConfiguration()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
            case "Environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private String name;
        private String description;
        private List<DataSource> dataSources;
        private String type;
        private Source appSource;
        private List<String> domains;
        private Boolean enableSsl;
        private SslConfiguration sslConfiguration;
        private Map<String, String> attributes;
        private List<EnvironmentVariable> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            this.appId(model.appId);
            this.name(model.name);
            this.description(model.description);
            this.dataSources(model.dataSources);
            this.type(model.type);
            this.appSource(model.appSource);
            this.domains(model.domains);
            this.enableSsl(model.enableSsl);
            this.sslConfiguration(model.sslConfiguration);
            this.attributes(model.attributes);
            this.environment(model.environment);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return this.dataSources != null ? (Collection)this.dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source.Builder getAppSource() {
            return this.appSource != null ? this.appSource.toBuilder() : null;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source.BuilderImpl appSource) {
            this.appSource = appSource != null ? appSource.build() : null;
        }

        public final Collection<String> getDomains() {
            return this.domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return this.enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration.Builder getSslConfiguration() {
            return this.sslConfiguration != null ? this.sslConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration.BuilderImpl sslConfiguration) {
            this.sslConfiguration = sslConfiguration != null ? sslConfiguration.build() : null;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAppRequest> {
        public Builder appId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder type(String var1);

        public Builder type(AppType var1);

        public Builder appSource(Source var1);

        default public Builder appSource(Consumer<Source.Builder> appSource) {
            return this.appSource((Source)((Source.Builder)Source.builder().apply(appSource)).build());
        }

        public Builder domains(Collection<String> var1);

        public Builder domains(String ... var1);

        public Builder enableSsl(Boolean var1);

        public Builder sslConfiguration(SslConfiguration var1);

        default public Builder sslConfiguration(Consumer<SslConfiguration.Builder> sslConfiguration) {
            return this.sslConfiguration((SslConfiguration)((SslConfiguration.Builder)SslConfiguration.builder().apply(sslConfiguration)).build());
        }

        public Builder attributes(Map<String, String> var1);

        public Builder environment(Collection<EnvironmentVariable> var1);

        public Builder environment(EnvironmentVariable ... var1);
    }
}

