/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ServiceErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceError
implements StructuredPojo,
ToCopyableBuilder<Builder, ServiceError> {
    private final String serviceErrorId;
    private final String stackId;
    private final String instanceId;
    private final String type;
    private final String message;
    private final String createdAt;

    private ServiceError(BuilderImpl builder) {
        this.serviceErrorId = builder.serviceErrorId;
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.type = builder.type;
        this.message = builder.message;
        this.createdAt = builder.createdAt;
    }

    public String serviceErrorId() {
        return this.serviceErrorId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceErrorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceError)) {
            return false;
        }
        ServiceError other = (ServiceError)obj;
        return Objects.equals(this.serviceErrorId(), other.serviceErrorId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serviceErrorId() != null) {
            sb.append("ServiceErrorId: ").append(this.serviceErrorId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceErrorId": {
                return Optional.of(clazz.cast(this.serviceErrorId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceErrorId;
        private String stackId;
        private String instanceId;
        private String type;
        private String message;
        private String createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceError model) {
            this.serviceErrorId(model.serviceErrorId);
            this.stackId(model.stackId);
            this.instanceId(model.instanceId);
            this.type(model.type);
            this.message(model.message);
            this.createdAt(model.createdAt);
        }

        public final String getServiceErrorId() {
            return this.serviceErrorId;
        }

        @Override
        public final Builder serviceErrorId(String serviceErrorId) {
            this.serviceErrorId = serviceErrorId;
            return this;
        }

        public final void setServiceErrorId(String serviceErrorId) {
            this.serviceErrorId = serviceErrorId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public ServiceError build() {
            return new ServiceError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceError> {
        public Builder serviceErrorId(String var1);

        public Builder stackId(String var1);

        public Builder instanceId(String var1);

        public Builder type(String var1);

        public Builder message(String var1);

        public Builder createdAt(String var1);
    }
}

