/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStacksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeStacksRequest> {
    private final List<String> stackIds;

    private DescribeStacksRequest(BuilderImpl builder) {
        this.stackIds = builder.stackIds;
    }

    public List<String> stackIds() {
        return this.stackIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksRequest)) {
            return false;
        }
        DescribeStacksRequest other = (DescribeStacksRequest)((Object)obj);
        return Objects.equals(this.stackIds(), other.stackIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackIds() != null) {
            sb.append("StackIds: ").append(this.stackIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackIds": {
                return Optional.of(clazz.cast(this.stackIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stackIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksRequest model) {
            this.stackIds(model.stackIds);
        }

        public final Collection<String> getStackIds() {
            return this.stackIds;
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String ... stackIds) {
            this.stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
        }

        public DescribeStacksRequest build() {
            return new DescribeStacksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStacksRequest> {
        public Builder stackIds(Collection<String> var1);

        public Builder stackIds(String ... var1);
    }
}

