/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRdsDbInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
    private final String stackId;
    private final List<String> rdsDbInstanceArns;

    private DescribeRdsDbInstancesRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.rdsDbInstanceArns = builder.rdsDbInstanceArns;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> rdsDbInstanceArns() {
        return this.rdsDbInstanceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesRequest)) {
            return false;
        }
        DescribeRdsDbInstancesRequest other = (DescribeRdsDbInstancesRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.rdsDbInstanceArns(), other.rdsDbInstanceArns());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.rdsDbInstanceArns() != null) {
            sb.append("RdsDbInstanceArns: ").append(this.rdsDbInstanceArns()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "RdsDbInstanceArns": {
                return Optional.of(clazz.cast(this.rdsDbInstanceArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> rdsDbInstanceArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesRequest model) {
            this.stackId(model.stackId);
            this.rdsDbInstanceArns(model.rdsDbInstanceArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRdsDbInstanceArns() {
            return this.rdsDbInstanceArns;
        }

        @Override
        public final Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstanceArns(String ... rdsDbInstanceArns) {
            this.rdsDbInstanceArns(Arrays.asList(rdsDbInstanceArns));
            return this;
        }

        public final void setRdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
        }

        public DescribeRdsDbInstancesRequest build() {
            return new DescribeRdsDbInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
        public Builder stackId(String var1);

        public Builder rdsDbInstanceArns(Collection<String> var1);

        public Builder rdsDbInstanceArns(String ... var1);
    }
}

