/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.services.opsworks.transform.AgentVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AgentVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, AgentVersion> {
    private final String version;
    private final StackConfigurationManager configurationManager;

    private AgentVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.configurationManager = builder.configurationManager;
    }

    public String version() {
        return this.version;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManager());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.configurationManager(), other.configurationManager());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.configurationManager()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "ConfigurationManager": {
                return Optional.of(clazz.cast(this.configurationManager()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            this.version(model.version);
            this.configurationManager(model.configurationManager);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public AgentVersion build() {
            return new AgentVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AgentVersion> {
        public Builder version(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        default public Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return this.configurationManager((StackConfigurationManager)((StackConfigurationManager.Builder)StackConfigurationManager.builder().apply(configurationManager)).build());
        }
    }
}

