/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.InstanceIdentity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterInstanceRequest> {
    private final String stackId;
    private final String hostname;
    private final String publicIp;
    private final String privateIp;
    private final String rsaPublicKey;
    private final String rsaPublicKeyFingerprint;
    private final InstanceIdentity instanceIdentity;

    private RegisterInstanceRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.hostname = builder.hostname;
        this.publicIp = builder.publicIp;
        this.privateIp = builder.privateIp;
        this.rsaPublicKey = builder.rsaPublicKey;
        this.rsaPublicKeyFingerprint = builder.rsaPublicKeyFingerprint;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public String stackId() {
        return this.stackId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String rsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String rsaPublicKeyFingerprint() {
        return this.rsaPublicKeyFingerprint;
    }

    public InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.privateIp() == null ? 0 : this.privateIp().hashCode());
        hashCode = 31 * hashCode + (this.rsaPublicKey() == null ? 0 : this.rsaPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.rsaPublicKeyFingerprint() == null ? 0 : this.rsaPublicKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.instanceIdentity() == null ? 0 : this.instanceIdentity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.privateIp() == null ^ this.privateIp() == null) {
            return false;
        }
        if (other.privateIp() != null && !other.privateIp().equals(this.privateIp())) {
            return false;
        }
        if (other.rsaPublicKey() == null ^ this.rsaPublicKey() == null) {
            return false;
        }
        if (other.rsaPublicKey() != null && !other.rsaPublicKey().equals(this.rsaPublicKey())) {
            return false;
        }
        if (other.rsaPublicKeyFingerprint() == null ^ this.rsaPublicKeyFingerprint() == null) {
            return false;
        }
        if (other.rsaPublicKeyFingerprint() != null && !other.rsaPublicKeyFingerprint().equals(this.rsaPublicKeyFingerprint())) {
            return false;
        }
        if (other.instanceIdentity() == null ^ this.instanceIdentity() == null) {
            return false;
        }
        return other.instanceIdentity() == null || other.instanceIdentity().equals(this.instanceIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.privateIp() != null) {
            sb.append("PrivateIp: ").append(this.privateIp()).append(",");
        }
        if (this.rsaPublicKey() != null) {
            sb.append("RsaPublicKey: ").append(this.rsaPublicKey()).append(",");
        }
        if (this.rsaPublicKeyFingerprint() != null) {
            sb.append("RsaPublicKeyFingerprint: ").append(this.rsaPublicKeyFingerprint()).append(",");
        }
        if (this.instanceIdentity() != null) {
            sb.append("InstanceIdentity: ").append(this.instanceIdentity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "PrivateIp": {
                return Optional.of(clazz.cast(this.privateIp()));
            }
            case "RsaPublicKey": {
                return Optional.of(clazz.cast(this.rsaPublicKey()));
            }
            case "RsaPublicKeyFingerprint": {
                return Optional.of(clazz.cast(this.rsaPublicKeyFingerprint()));
            }
            case "InstanceIdentity": {
                return Optional.of(clazz.cast(this.instanceIdentity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String hostname;
        private String publicIp;
        private String privateIp;
        private String rsaPublicKey;
        private String rsaPublicKeyFingerprint;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            this.stackId(model.stackId);
            this.hostname(model.hostname);
            this.publicIp(model.publicIp);
            this.privateIp(model.privateIp);
            this.rsaPublicKey(model.rsaPublicKey);
            this.rsaPublicKeyFingerprint(model.rsaPublicKeyFingerprint);
            this.instanceIdentity(model.instanceIdentity);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getRsaPublicKey() {
            return this.rsaPublicKey;
        }

        @Override
        public final Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public final void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public final String getRsaPublicKeyFingerprint() {
            return this.rsaPublicKeyFingerprint;
        }

        @Override
        public final Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
            return this;
        }

        public final void setRsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return this.instanceIdentity != null ? this.instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterInstanceRequest> {
        public Builder stackId(String var1);

        public Builder hostname(String var1);

        public Builder publicIp(String var1);

        public Builder privateIp(String var1);

        public Builder rsaPublicKey(String var1);

        public Builder rsaPublicKeyFingerprint(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);
    }
}

