/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.Volume;
import software.amazon.awssdk.services.opsworks.model.VolumesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVolumesResponse> {
    private final List<Volume> volumes;

    private DescribeVolumesResponse(BuilderImpl builder) {
        this.volumes = builder.volumes;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumes() == null ? 0 : this.volumes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesResponse)) {
            return false;
        }
        DescribeVolumesResponse other = (DescribeVolumesResponse)((Object)obj);
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        return other.volumes() == null || other.volumes().equals(this.volumes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Volumes": {
                return Optional.of(clazz.cast(this.volumes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Volume> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesResponse model) {
            this.volumes(model.volumes);
        }

        public final Collection<Volume.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        public DescribeVolumesResponse build() {
            return new DescribeVolumesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumesResponse> {
        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);
    }
}

