/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAgentVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAgentVersionsRequest> {
    private final String stackId;
    private final StackConfigurationManager configurationManager;

    private DescribeAgentVersionsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.configurationManager = builder.configurationManager;
    }

    public String stackId() {
        return this.stackId;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.configurationManager() == null ? 0 : this.configurationManager().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsRequest)) {
            return false;
        }
        DescribeAgentVersionsRequest other = (DescribeAgentVersionsRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        return other.configurationManager() == null || other.configurationManager().equals(this.configurationManager());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.configurationManager()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "ConfigurationManager": {
                return Optional.of(clazz.cast(this.configurationManager()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsRequest model) {
            this.stackId(model.stackId);
            this.configurationManager(model.configurationManager);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public DescribeAgentVersionsRequest build() {
            return new DescribeAgentVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAgentVersionsRequest> {
        public Builder stackId(String var1);

        public Builder configurationManager(StackConfigurationManager var1);
    }
}

