/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStream;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStreamsCopier;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLogsConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLogsConfiguration> {
    private final Boolean enabled;
    private final List<CloudWatchLogsLogStream> logStreams;

    private CloudWatchLogsConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logStreams = builder.logStreams;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<CloudWatchLogsLogStream> logStreams() {
        return this.logStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.logStreams() == null ? 0 : this.logStreams().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfiguration)) {
            return false;
        }
        CloudWatchLogsConfiguration other = (CloudWatchLogsConfiguration)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.logStreams() == null ^ this.logStreams() == null) {
            return false;
        }
        return other.logStreams() == null || other.logStreams().equals(this.logStreams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.logStreams() != null) {
            sb.append("LogStreams: ").append(this.logStreams()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "LogStreams": {
                return Optional.of(clazz.cast(this.logStreams()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<CloudWatchLogsLogStream> logStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfiguration model) {
            this.enabled(model.enabled);
            this.logStreams(model.logStreams);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<CloudWatchLogsLogStream.Builder> getLogStreams() {
            return this.logStreams != null ? (Collection)this.logStreams.stream().map(CloudWatchLogsLogStream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(CloudWatchLogsLogStream ... logStreams) {
            this.logStreams(Arrays.asList(logStreams));
            return this;
        }

        public final void setLogStreams(Collection<CloudWatchLogsLogStream.BuilderImpl> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copyFromBuilder(logStreams);
        }

        public CloudWatchLogsConfiguration build() {
            return new CloudWatchLogsConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLogsConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder logStreams(Collection<CloudWatchLogsLogStream> var1);

        public Builder logStreams(CloudWatchLogsLogStream ... var1);
    }
}

