/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.StackAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.StackAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloneStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CloneStackRequest> {
    private final String sourceStackId;
    private final String name;
    private final String region;
    private final String vpcId;
    private final Map<String, String> attributes;
    private final String serviceRoleArn;
    private final String defaultInstanceProfileArn;
    private final String defaultOs;
    private final String hostnameTheme;
    private final String defaultAvailabilityZone;
    private final String defaultSubnetId;
    private final String customJson;
    private final StackConfigurationManager configurationManager;
    private final ChefConfiguration chefConfiguration;
    private final Boolean useCustomCookbooks;
    private final Boolean useOpsworksSecurityGroups;
    private final Source customCookbooksSource;
    private final String defaultSshKeyName;
    private final Boolean clonePermissions;
    private final List<String> cloneAppIds;
    private final String defaultRootDeviceType;
    private final String agentVersion;

    private CloneStackRequest(BuilderImpl builder) {
        this.sourceStackId = builder.sourceStackId;
        this.name = builder.name;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.clonePermissions = builder.clonePermissions;
        this.cloneAppIds = builder.cloneAppIds;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    public String sourceStackId() {
        return this.sourceStackId;
    }

    public String name() {
        return this.name;
    }

    public String region() {
        return this.region;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Map<StackAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, StackAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)StackAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesStrings() {
        return this.attributes;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public String defaultInstanceProfileArn() {
        return this.defaultInstanceProfileArn;
    }

    public String defaultOs() {
        return this.defaultOs;
    }

    public String hostnameTheme() {
        return this.hostnameTheme;
    }

    public String defaultAvailabilityZone() {
        return this.defaultAvailabilityZone;
    }

    public String defaultSubnetId() {
        return this.defaultSubnetId;
    }

    public String customJson() {
        return this.customJson;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public ChefConfiguration chefConfiguration() {
        return this.chefConfiguration;
    }

    public Boolean useCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public Boolean useOpsworksSecurityGroups() {
        return this.useOpsworksSecurityGroups;
    }

    public Source customCookbooksSource() {
        return this.customCookbooksSource;
    }

    public String defaultSshKeyName() {
        return this.defaultSshKeyName;
    }

    public Boolean clonePermissions() {
        return this.clonePermissions;
    }

    public List<String> cloneAppIds() {
        return this.cloneAppIds;
    }

    public RootDeviceType defaultRootDeviceType() {
        return RootDeviceType.fromValue(this.defaultRootDeviceType);
    }

    public String defaultRootDeviceTypeString() {
        return this.defaultRootDeviceType;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceStackId() == null ? 0 : this.sourceStackId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.attributesStrings() == null ? 0 : this.attributesStrings().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.defaultInstanceProfileArn() == null ? 0 : this.defaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.defaultOs() == null ? 0 : this.defaultOs().hashCode());
        hashCode = 31 * hashCode + (this.hostnameTheme() == null ? 0 : this.hostnameTheme().hashCode());
        hashCode = 31 * hashCode + (this.defaultAvailabilityZone() == null ? 0 : this.defaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.defaultSubnetId() == null ? 0 : this.defaultSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.customJson() == null ? 0 : this.customJson().hashCode());
        hashCode = 31 * hashCode + (this.configurationManager() == null ? 0 : this.configurationManager().hashCode());
        hashCode = 31 * hashCode + (this.chefConfiguration() == null ? 0 : this.chefConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.useCustomCookbooks() == null ? 0 : this.useCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + (this.useOpsworksSecurityGroups() == null ? 0 : this.useOpsworksSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.customCookbooksSource() == null ? 0 : this.customCookbooksSource().hashCode());
        hashCode = 31 * hashCode + (this.defaultSshKeyName() == null ? 0 : this.defaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.clonePermissions() == null ? 0 : this.clonePermissions().hashCode());
        hashCode = 31 * hashCode + (this.cloneAppIds() == null ? 0 : this.cloneAppIds().hashCode());
        hashCode = 31 * hashCode + (this.defaultRootDeviceTypeString() == null ? 0 : this.defaultRootDeviceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneStackRequest)) {
            return false;
        }
        CloneStackRequest other = (CloneStackRequest)((Object)obj);
        if (other.sourceStackId() == null ^ this.sourceStackId() == null) {
            return false;
        }
        if (other.sourceStackId() != null && !other.sourceStackId().equals(this.sourceStackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.attributesStrings() == null ^ this.attributesStrings() == null) {
            return false;
        }
        if (other.attributesStrings() != null && !other.attributesStrings().equals(this.attributesStrings())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.defaultInstanceProfileArn() == null ^ this.defaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.defaultInstanceProfileArn() != null && !other.defaultInstanceProfileArn().equals(this.defaultInstanceProfileArn())) {
            return false;
        }
        if (other.defaultOs() == null ^ this.defaultOs() == null) {
            return false;
        }
        if (other.defaultOs() != null && !other.defaultOs().equals(this.defaultOs())) {
            return false;
        }
        if (other.hostnameTheme() == null ^ this.hostnameTheme() == null) {
            return false;
        }
        if (other.hostnameTheme() != null && !other.hostnameTheme().equals(this.hostnameTheme())) {
            return false;
        }
        if (other.defaultAvailabilityZone() == null ^ this.defaultAvailabilityZone() == null) {
            return false;
        }
        if (other.defaultAvailabilityZone() != null && !other.defaultAvailabilityZone().equals(this.defaultAvailabilityZone())) {
            return false;
        }
        if (other.defaultSubnetId() == null ^ this.defaultSubnetId() == null) {
            return false;
        }
        if (other.defaultSubnetId() != null && !other.defaultSubnetId().equals(this.defaultSubnetId())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        if (other.chefConfiguration() == null ^ this.chefConfiguration() == null) {
            return false;
        }
        if (other.chefConfiguration() != null && !other.chefConfiguration().equals(this.chefConfiguration())) {
            return false;
        }
        if (other.useCustomCookbooks() == null ^ this.useCustomCookbooks() == null) {
            return false;
        }
        if (other.useCustomCookbooks() != null && !other.useCustomCookbooks().equals(this.useCustomCookbooks())) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() == null ^ this.useOpsworksSecurityGroups() == null) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() != null && !other.useOpsworksSecurityGroups().equals(this.useOpsworksSecurityGroups())) {
            return false;
        }
        if (other.customCookbooksSource() == null ^ this.customCookbooksSource() == null) {
            return false;
        }
        if (other.customCookbooksSource() != null && !other.customCookbooksSource().equals(this.customCookbooksSource())) {
            return false;
        }
        if (other.defaultSshKeyName() == null ^ this.defaultSshKeyName() == null) {
            return false;
        }
        if (other.defaultSshKeyName() != null && !other.defaultSshKeyName().equals(this.defaultSshKeyName())) {
            return false;
        }
        if (other.clonePermissions() == null ^ this.clonePermissions() == null) {
            return false;
        }
        if (other.clonePermissions() != null && !other.clonePermissions().equals(this.clonePermissions())) {
            return false;
        }
        if (other.cloneAppIds() == null ^ this.cloneAppIds() == null) {
            return false;
        }
        if (other.cloneAppIds() != null && !other.cloneAppIds().equals(this.cloneAppIds())) {
            return false;
        }
        if (other.defaultRootDeviceTypeString() == null ^ this.defaultRootDeviceTypeString() == null) {
            return false;
        }
        if (other.defaultRootDeviceTypeString() != null && !other.defaultRootDeviceTypeString().equals(this.defaultRootDeviceTypeString())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        return other.agentVersion() == null || other.agentVersion().equals(this.agentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceStackId() != null) {
            sb.append("SourceStackId: ").append(this.sourceStackId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.defaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: ").append(this.defaultInstanceProfileArn()).append(",");
        }
        if (this.defaultOs() != null) {
            sb.append("DefaultOs: ").append(this.defaultOs()).append(",");
        }
        if (this.hostnameTheme() != null) {
            sb.append("HostnameTheme: ").append(this.hostnameTheme()).append(",");
        }
        if (this.defaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: ").append(this.defaultAvailabilityZone()).append(",");
        }
        if (this.defaultSubnetId() != null) {
            sb.append("DefaultSubnetId: ").append(this.defaultSubnetId()).append(",");
        }
        if (this.customJson() != null) {
            sb.append("CustomJson: ").append(this.customJson()).append(",");
        }
        if (this.configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.configurationManager()).append(",");
        }
        if (this.chefConfiguration() != null) {
            sb.append("ChefConfiguration: ").append(this.chefConfiguration()).append(",");
        }
        if (this.useCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: ").append(this.useCustomCookbooks()).append(",");
        }
        if (this.useOpsworksSecurityGroups() != null) {
            sb.append("UseOpsworksSecurityGroups: ").append(this.useOpsworksSecurityGroups()).append(",");
        }
        if (this.customCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: ").append(this.customCookbooksSource()).append(",");
        }
        if (this.defaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: ").append(this.defaultSshKeyName()).append(",");
        }
        if (this.clonePermissions() != null) {
            sb.append("ClonePermissions: ").append(this.clonePermissions()).append(",");
        }
        if (this.cloneAppIds() != null) {
            sb.append("CloneAppIds: ").append(this.cloneAppIds()).append(",");
        }
        if (this.defaultRootDeviceTypeString() != null) {
            sb.append("DefaultRootDeviceType: ").append(this.defaultRootDeviceTypeString()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceStackId": {
                return Optional.of(clazz.cast(this.sourceStackId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "DefaultInstanceProfileArn": {
                return Optional.of(clazz.cast(this.defaultInstanceProfileArn()));
            }
            case "DefaultOs": {
                return Optional.of(clazz.cast(this.defaultOs()));
            }
            case "HostnameTheme": {
                return Optional.of(clazz.cast(this.hostnameTheme()));
            }
            case "DefaultAvailabilityZone": {
                return Optional.of(clazz.cast(this.defaultAvailabilityZone()));
            }
            case "DefaultSubnetId": {
                return Optional.of(clazz.cast(this.defaultSubnetId()));
            }
            case "CustomJson": {
                return Optional.of(clazz.cast(this.customJson()));
            }
            case "ConfigurationManager": {
                return Optional.of(clazz.cast(this.configurationManager()));
            }
            case "ChefConfiguration": {
                return Optional.of(clazz.cast(this.chefConfiguration()));
            }
            case "UseCustomCookbooks": {
                return Optional.of(clazz.cast(this.useCustomCookbooks()));
            }
            case "UseOpsworksSecurityGroups": {
                return Optional.of(clazz.cast(this.useOpsworksSecurityGroups()));
            }
            case "CustomCookbooksSource": {
                return Optional.of(clazz.cast(this.customCookbooksSource()));
            }
            case "DefaultSshKeyName": {
                return Optional.of(clazz.cast(this.defaultSshKeyName()));
            }
            case "ClonePermissions": {
                return Optional.of(clazz.cast(this.clonePermissions()));
            }
            case "CloneAppIds": {
                return Optional.of(clazz.cast(this.cloneAppIds()));
            }
            case "DefaultRootDeviceType": {
                return Optional.of(clazz.cast(this.defaultRootDeviceTypeString()));
            }
            case "AgentVersion": {
                return Optional.of(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceStackId;
        private String name;
        private String region;
        private String vpcId;
        private Map<String, String> attributes;
        private String serviceRoleArn;
        private String defaultInstanceProfileArn;
        private String defaultOs;
        private String hostnameTheme;
        private String defaultAvailabilityZone;
        private String defaultSubnetId;
        private String customJson;
        private StackConfigurationManager configurationManager;
        private ChefConfiguration chefConfiguration;
        private Boolean useCustomCookbooks;
        private Boolean useOpsworksSecurityGroups;
        private Source customCookbooksSource;
        private String defaultSshKeyName;
        private Boolean clonePermissions;
        private List<String> cloneAppIds;
        private String defaultRootDeviceType;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneStackRequest model) {
            this.sourceStackId(model.sourceStackId);
            this.name(model.name);
            this.region(model.region);
            this.vpcId(model.vpcId);
            this.attributes(model.attributes);
            this.serviceRoleArn(model.serviceRoleArn);
            this.defaultInstanceProfileArn(model.defaultInstanceProfileArn);
            this.defaultOs(model.defaultOs);
            this.hostnameTheme(model.hostnameTheme);
            this.defaultAvailabilityZone(model.defaultAvailabilityZone);
            this.defaultSubnetId(model.defaultSubnetId);
            this.customJson(model.customJson);
            this.configurationManager(model.configurationManager);
            this.chefConfiguration(model.chefConfiguration);
            this.useCustomCookbooks(model.useCustomCookbooks);
            this.useOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            this.customCookbooksSource(model.customCookbooksSource);
            this.defaultSshKeyName(model.defaultSshKeyName);
            this.clonePermissions(model.clonePermissions);
            this.cloneAppIds(model.cloneAppIds);
            this.defaultRootDeviceType(model.defaultRootDeviceType);
            this.agentVersion(model.agentVersion);
        }

        public final String getSourceStackId() {
            return this.sourceStackId;
        }

        @Override
        public final Builder sourceStackId(String sourceStackId) {
            this.sourceStackId = sourceStackId;
            return this;
        }

        public final void setSourceStackId(String sourceStackId) {
            this.sourceStackId = sourceStackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return this.defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return this.defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return this.hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return this.defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return this.defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public final ChefConfiguration.Builder getChefConfiguration() {
            return this.chefConfiguration != null ? this.chefConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration.BuilderImpl chefConfiguration) {
            this.chefConfiguration = chefConfiguration != null ? chefConfiguration.build() : null;
        }

        public final Boolean getUseCustomCookbooks() {
            return this.useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return this.useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source.Builder getCustomCookbooksSource() {
            return this.customCookbooksSource != null ? this.customCookbooksSource.toBuilder() : null;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source.BuilderImpl customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource != null ? customCookbooksSource.build() : null;
        }

        public final String getDefaultSshKeyName() {
            return this.defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final Boolean getClonePermissions() {
            return this.clonePermissions;
        }

        @Override
        public final Builder clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        public final void setClonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
        }

        public final Collection<String> getCloneAppIds() {
            return this.cloneAppIds;
        }

        @Override
        public final Builder cloneAppIds(Collection<String> cloneAppIds) {
            this.cloneAppIds = StringsCopier.copy(cloneAppIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloneAppIds(String ... cloneAppIds) {
            this.cloneAppIds(Arrays.asList(cloneAppIds));
            return this;
        }

        public final void setCloneAppIds(Collection<String> cloneAppIds) {
            this.cloneAppIds = StringsCopier.copy(cloneAppIds);
        }

        public final String getDefaultRootDeviceType() {
            return this.defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public CloneStackRequest build() {
            return new CloneStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloneStackRequest> {
        public Builder sourceStackId(String var1);

        public Builder name(String var1);

        public Builder region(String var1);

        public Builder vpcId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder serviceRoleArn(String var1);

        public Builder defaultInstanceProfileArn(String var1);

        public Builder defaultOs(String var1);

        public Builder hostnameTheme(String var1);

        public Builder defaultAvailabilityZone(String var1);

        public Builder defaultSubnetId(String var1);

        public Builder customJson(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        public Builder chefConfiguration(ChefConfiguration var1);

        public Builder useCustomCookbooks(Boolean var1);

        public Builder useOpsworksSecurityGroups(Boolean var1);

        public Builder customCookbooksSource(Source var1);

        public Builder defaultSshKeyName(String var1);

        public Builder clonePermissions(Boolean var1);

        public Builder cloneAppIds(Collection<String> var1);

        public Builder cloneAppIds(String ... var1);

        public Builder defaultRootDeviceType(String var1);

        public Builder defaultRootDeviceType(RootDeviceType var1);

        public Builder agentVersion(String var1);
    }
}

