/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariable;

@SdkInternalApi
public class EnvironmentVariableMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Boolean> SECURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Secure").build();
    private static final EnvironmentVariableMarshaller INSTANCE = new EnvironmentVariableMarshaller();

    public static EnvironmentVariableMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentVariable environmentVariable, ProtocolMarshaller protocolMarshaller) {
        if (environmentVariable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)environmentVariable.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)environmentVariable.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)environmentVariable.secure(), SECURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

