/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.TemporaryCredentialMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TemporaryCredential
implements StructuredPojo,
ToCopyableBuilder<Builder, TemporaryCredential> {
    private final String username;
    private final String password;
    private final Integer validForInMinutes;
    private final String instanceId;

    private TemporaryCredential(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.validForInMinutes = builder.validForInMinutes;
        this.instanceId = builder.instanceId;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Integer validForInMinutes() {
        return this.validForInMinutes;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.password() == null ? 0 : this.password().hashCode());
        hashCode = 31 * hashCode + (this.validForInMinutes() == null ? 0 : this.validForInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporaryCredential)) {
            return false;
        }
        TemporaryCredential other = (TemporaryCredential)obj;
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        if (other.validForInMinutes() == null ^ this.validForInMinutes() == null) {
            return false;
        }
        if (other.validForInMinutes() != null && !other.validForInMinutes().equals(this.validForInMinutes())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        return other.instanceId() == null || other.instanceId().equals(this.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        if (this.validForInMinutes() != null) {
            sb.append("ValidForInMinutes: ").append(this.validForInMinutes()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemporaryCredentialMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private Integer validForInMinutes;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(TemporaryCredential model) {
            this.setUsername(model.username);
            this.setPassword(model.password);
            this.setValidForInMinutes(model.validForInMinutes);
            this.setInstanceId(model.instanceId);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getValidForInMinutes() {
            return this.validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public TemporaryCredential build() {
            return new TemporaryCredential(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TemporaryCredential> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder validForInMinutes(Integer var1);

        public Builder instanceId(String var1);
    }
}

