/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRaidArraysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRaidArraysRequest> {
    private final String instanceId;
    private final String stackId;
    private final List<String> raidArrayIds;

    private DescribeRaidArraysRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayIds = builder.raidArrayIds;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> raidArrayIds() {
        return this.raidArrayIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.raidArrayIds() == null ? 0 : this.raidArrayIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysRequest)) {
            return false;
        }
        DescribeRaidArraysRequest other = (DescribeRaidArraysRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.raidArrayIds() == null ^ this.raidArrayIds() == null) {
            return false;
        }
        return other.raidArrayIds() == null || other.raidArrayIds().equals(this.raidArrayIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.raidArrayIds() != null) {
            sb.append("RaidArrayIds: ").append(this.raidArrayIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private List<String> raidArrayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysRequest model) {
            this.setInstanceId(model.instanceId);
            this.setStackId(model.stackId);
            this.setRaidArrayIds(model.raidArrayIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRaidArrayIds() {
            return this.raidArrayIds;
        }

        @Override
        public final Builder raidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrayIds(String ... raidArrayIds) {
            this.raidArrayIds(Arrays.asList(raidArrayIds));
            return this;
        }

        public final void setRaidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
        }

        public DescribeRaidArraysRequest build() {
            return new DescribeRaidArraysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRaidArraysRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder raidArrayIds(Collection<String> var1);

        public Builder raidArrayIds(String ... var1);
    }
}

