/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ShutdownEventConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShutdownEventConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ShutdownEventConfiguration> {
    private final Integer executionTimeout;
    private final Boolean delayUntilElbConnectionsDrained;

    private ShutdownEventConfiguration(BuilderImpl builder) {
        this.executionTimeout = builder.executionTimeout;
        this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
    }

    public Integer executionTimeout() {
        return this.executionTimeout;
    }

    public Boolean delayUntilElbConnectionsDrained() {
        return this.delayUntilElbConnectionsDrained;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.executionTimeout() == null ? 0 : this.executionTimeout().hashCode());
        hashCode = 31 * hashCode + (this.delayUntilElbConnectionsDrained() == null ? 0 : this.delayUntilElbConnectionsDrained().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShutdownEventConfiguration)) {
            return false;
        }
        ShutdownEventConfiguration other = (ShutdownEventConfiguration)obj;
        if (other.executionTimeout() == null ^ this.executionTimeout() == null) {
            return false;
        }
        if (other.executionTimeout() != null && !other.executionTimeout().equals(this.executionTimeout())) {
            return false;
        }
        if (other.delayUntilElbConnectionsDrained() == null ^ this.delayUntilElbConnectionsDrained() == null) {
            return false;
        }
        return other.delayUntilElbConnectionsDrained() == null || other.delayUntilElbConnectionsDrained().equals(this.delayUntilElbConnectionsDrained());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.executionTimeout() != null) {
            sb.append("ExecutionTimeout: ").append(this.executionTimeout()).append(",");
        }
        if (this.delayUntilElbConnectionsDrained() != null) {
            sb.append("DelayUntilElbConnectionsDrained: ").append(this.delayUntilElbConnectionsDrained()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShutdownEventConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer executionTimeout;
        private Boolean delayUntilElbConnectionsDrained;

        private BuilderImpl() {
        }

        private BuilderImpl(ShutdownEventConfiguration model) {
            this.setExecutionTimeout(model.executionTimeout);
            this.setDelayUntilElbConnectionsDrained(model.delayUntilElbConnectionsDrained);
        }

        public final Integer getExecutionTimeout() {
            return this.executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public final Boolean getDelayUntilElbConnectionsDrained() {
            return this.delayUntilElbConnectionsDrained;
        }

        @Override
        public final Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
            return this;
        }

        public final void setDelayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
        }

        public ShutdownEventConfiguration build() {
            return new ShutdownEventConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShutdownEventConfiguration> {
        public Builder executionTimeout(Integer var1);

        public Builder delayUntilElbConnectionsDrained(Boolean var1);
    }
}

