/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.Permission;
import software.amazon.awssdk.services.opsworks.model.PermissionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePermissionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePermissionsResponse> {
    private final List<Permission> permissions;

    private DescribePermissionsResponse(BuilderImpl builder) {
        this.permissions = builder.permissions;
    }

    public List<Permission> permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.permissions() == null ? 0 : this.permissions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsResponse)) {
            return false;
        }
        DescribePermissionsResponse other = (DescribePermissionsResponse)((Object)obj);
        if (other.permissions() == null ^ this.permissions() == null) {
            return false;
        }
        return other.permissions() == null || other.permissions().equals(this.permissions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.permissions() != null) {
            sb.append("Permissions: ").append(this.permissions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Permission> permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsResponse model) {
            this.setPermissions(model.permissions);
        }

        public final Collection<Permission> getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
        }

        @SafeVarargs
        public final void setPermissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
        }

        public DescribePermissionsResponse build() {
            return new DescribePermissionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePermissionsResponse> {
        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);
    }
}

