/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteInstanceRequest> {
    private final String instanceId;
    private final Boolean deleteElasticIp;
    private final Boolean deleteVolumes;

    private DeleteInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.deleteElasticIp = builder.deleteElasticIp;
        this.deleteVolumes = builder.deleteVolumes;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean deleteElasticIp() {
        return this.deleteElasticIp;
    }

    public Boolean deleteVolumes() {
        return this.deleteVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.deleteElasticIp() == null ? 0 : this.deleteElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.deleteVolumes() == null ? 0 : this.deleteVolumes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.deleteElasticIp() == null ^ this.deleteElasticIp() == null) {
            return false;
        }
        if (other.deleteElasticIp() != null && !other.deleteElasticIp().equals(this.deleteElasticIp())) {
            return false;
        }
        if (other.deleteVolumes() == null ^ this.deleteVolumes() == null) {
            return false;
        }
        return other.deleteVolumes() == null || other.deleteVolumes().equals(this.deleteVolumes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.deleteElasticIp() != null) {
            sb.append("DeleteElasticIp: ").append(this.deleteElasticIp()).append(",");
        }
        if (this.deleteVolumes() != null) {
            sb.append("DeleteVolumes: ").append(this.deleteVolumes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean deleteElasticIp;
        private Boolean deleteVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            this.setInstanceId(model.instanceId);
            this.setDeleteElasticIp(model.deleteElasticIp);
            this.setDeleteVolumes(model.deleteVolumes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getDeleteElasticIp() {
            return this.deleteElasticIp;
        }

        @Override
        public final Builder deleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
            return this;
        }

        public final void setDeleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
        }

        public final Boolean getDeleteVolumes() {
            return this.deleteVolumes;
        }

        @Override
        public final Builder deleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
            return this;
        }

        public final void setDeleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
        }

        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder deleteElasticIp(Boolean var1);

        public Builder deleteVolumes(Boolean var1);
    }
}

