/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.UpdateAppRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateAppRequestModelMarshaller {
    private static final MarshallingInfo<String> APPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<List> DATASOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSources").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> APPSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppSource").isBinary(false).build();
    private static final MarshallingInfo<List> DOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domains").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLESSL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableSsl").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SSLCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").isBinary(false).build();
    private static final UpdateAppRequestModelMarshaller INSTANCE = new UpdateAppRequestModelMarshaller();

    private UpdateAppRequestModelMarshaller() {
    }

    public static UpdateAppRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateAppRequest updateAppRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateAppRequest), (String)"updateAppRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateAppRequest.appId(), APPID_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateAppRequest.dataSources(), DATASOURCES_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.appSource(), APPSOURCE_BINDING);
            protocolMarshaller.marshall(updateAppRequest.domains(), DOMAINS_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.enableSsl(), ENABLESSL_BINDING);
            protocolMarshaller.marshall((Object)updateAppRequest.sslConfiguration(), SSLCONFIGURATION_BINDING);
            protocolMarshaller.marshall(updateAppRequest.attributesAsStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(updateAppRequest.environment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

