/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RdsDbInstanceMarshaller {
    private static final MarshallingInfo<String> RDSDBINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RdsDbInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> DBINSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbInstanceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> DBUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbUser").isBinary(false).build();
    private static final MarshallingInfo<String> DBPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbPassword").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Engine").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> MISSINGONRDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingOnRds").isBinary(false).build();
    private static final RdsDbInstanceMarshaller INSTANCE = new RdsDbInstanceMarshaller();

    private RdsDbInstanceMarshaller() {
    }

    public static RdsDbInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RdsDbInstance rdsDbInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rdsDbInstance, (String)"rdsDbInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rdsDbInstance.rdsDbInstanceArn(), RDSDBINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.dbInstanceIdentifier(), DBINSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.dbUser(), DBUSER_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.dbPassword(), DBPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.engine(), ENGINE_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)rdsDbInstance.missingOnRds(), MISSINGONRDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

