/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.EbsBlockDevice;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EbsBlockDeviceMarshaller {
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").isBinary(false).build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").isBinary(false).build();
    private static final MarshallingInfo<Integer> VOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSize").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DELETEONTERMINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteOnTermination").isBinary(false).build();
    private static final EbsBlockDeviceMarshaller INSTANCE = new EbsBlockDeviceMarshaller();

    private EbsBlockDeviceMarshaller() {
    }

    public static EbsBlockDeviceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EbsBlockDevice ebsBlockDevice, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ebsBlockDevice, (String)"ebsBlockDevice");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ebsBlockDevice.snapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.iops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.volumeSize(), VOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.volumeTypeAsString(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.deleteOnTermination(), DELETEONTERMINATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

