/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchLogsLogStreamMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> DATETIMEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatetimeFormat").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZone").isBinary(false).build();
    private static final MarshallingInfo<String> FILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("File").isBinary(false).build();
    private static final MarshallingInfo<String> FILEFINGERPRINTLINES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileFingerprintLines").isBinary(false).build();
    private static final MarshallingInfo<String> MULTILINESTARTPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiLineStartPattern").isBinary(false).build();
    private static final MarshallingInfo<String> INITIALPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialPosition").isBinary(false).build();
    private static final MarshallingInfo<String> ENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encoding").isBinary(false).build();
    private static final MarshallingInfo<Integer> BUFFERDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferDuration").isBinary(false).build();
    private static final MarshallingInfo<Integer> BATCHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> BATCHSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchSize").isBinary(false).build();
    private static final CloudWatchLogsLogStreamMarshaller INSTANCE = new CloudWatchLogsLogStreamMarshaller();

    private CloudWatchLogsLogStreamMarshaller() {
    }

    public static CloudWatchLogsLogStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLogsLogStream cloudWatchLogsLogStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchLogsLogStream, (String)"cloudWatchLogsLogStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.datetimeFormat(), DATETIMEFORMAT_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.timeZoneAsString(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.file(), FILE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.fileFingerprintLines(), FILEFINGERPRINTLINES_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.multiLineStartPattern(), MULTILINESTARTPATTERN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.initialPositionAsString(), INITIALPOSITION_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.encodingAsString(), ENCODING_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.bufferDuration(), BUFFERDURATION_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.batchCount(), BATCHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.batchSize(), BATCHSIZE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

