/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CloneStackRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloneStackRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCESTACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceStackId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTINSTANCEPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultOs").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAMETHEME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostnameTheme").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTAVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTSUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultSubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATIONMANAGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationManager").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CHEFCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChefConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USECUSTOMCOOKBOOKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseCustomCookbooks").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USEOPSWORKSSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseOpsworksSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMCOOKBOOKSSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomCookbooksSource").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTSSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultSshKeyName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CLONEPERMISSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClonePermissions").isBinary(false).build();
    private static final MarshallingInfo<List> CLONEAPPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloneAppIds").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTROOTDEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRootDeviceType").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();
    private static final CloneStackRequestModelMarshaller INSTANCE = new CloneStackRequestModelMarshaller();

    private CloneStackRequestModelMarshaller() {
    }

    public static CloneStackRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloneStackRequest cloneStackRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)cloneStackRequest), (String)"cloneStackRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloneStackRequest.sourceStackId(), SOURCESTACKID_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(cloneStackRequest.attributesAsStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultInstanceProfileArn(), DEFAULTINSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultOs(), DEFAULTOS_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.hostnameTheme(), HOSTNAMETHEME_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultAvailabilityZone(), DEFAULTAVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultSubnetId(), DEFAULTSUBNETID_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.customJson(), CUSTOMJSON_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.configurationManager(), CONFIGURATIONMANAGER_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.chefConfiguration(), CHEFCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.useCustomCookbooks(), USECUSTOMCOOKBOOKS_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.useOpsworksSecurityGroups(), USEOPSWORKSSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.customCookbooksSource(), CUSTOMCOOKBOOKSSOURCE_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultSshKeyName(), DEFAULTSSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.clonePermissions(), CLONEPERMISSIONS_BINDING);
            protocolMarshaller.marshall(cloneStackRequest.cloneAppIds(), CLONEAPPIDS_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.defaultRootDeviceTypeAsString(), DEFAULTROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)cloneStackRequest.agentVersion(), AGENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

