/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserProfileRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, UpdateUserProfileRequest> {
    private final String iamUserArn;
    private final String sshUsername;
    private final String sshPublicKey;
    private final Boolean allowSelfManagement;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String sshUsername() {
        return this.sshUsername;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public Boolean allowSelfManagement() {
        return this.allowSelfManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSelfManagement());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest)((Object)obj);
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.sshUsername(), other.sshUsername()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.allowSelfManagement(), other.allowSelfManagement());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserProfileRequest").add("IamUserArn", (Object)this.iamUserArn()).add("SshUsername", (Object)this.sshUsername()).add("SshPublicKey", (Object)this.sshPublicKey()).add("AllowSelfManagement", (Object)this.allowSelfManagement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "SshUsername": {
                return Optional.ofNullable(clazz.cast(this.sshUsername()));
            }
            case "SshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "AllowSelfManagement": {
                return Optional.ofNullable(clazz.cast(this.allowSelfManagement()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String sshUsername;
        private String sshPublicKey;
        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            this.iamUserArn(model.iamUserArn);
            this.sshUsername(model.sshUsername);
            this.sshPublicKey(model.sshPublicKey);
            this.allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getSshUsername() {
            return this.sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getAllowSelfManagement() {
            return this.allowSelfManagement;
        }

        @Override
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, UpdateUserProfileRequest> {
        public Builder iamUserArn(String var1);

        public Builder sshUsername(String var1);

        public Builder sshPublicKey(String var1);

        public Builder allowSelfManagement(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

