/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SslConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SslConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, SslConfiguration> {
    private final String certificate;
    private final String privateKey;
    private final String chain;

    private SslConfiguration(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.chain = builder.chain;
    }

    public String certificate() {
        return this.certificate;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String chain() {
        return this.chain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.chain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslConfiguration)) {
            return false;
        }
        SslConfiguration other = (SslConfiguration)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.chain(), other.chain());
    }

    public String toString() {
        return ToString.builder((String)"SslConfiguration").add("Certificate", (Object)this.certificate()).add("PrivateKey", (Object)this.privateKey()).add("Chain", (Object)this.chain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "Chain": {
                return Optional.ofNullable(clazz.cast(this.chain()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SslConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificate;
        private String privateKey;
        private String chain;

        private BuilderImpl() {
        }

        private BuilderImpl(SslConfiguration model) {
            this.certificate(model.certificate);
            this.privateKey(model.privateKey);
            this.chain(model.chain);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getChain() {
            return this.chain;
        }

        @Override
        public final Builder chain(String chain) {
            this.chain = chain;
            return this;
        }

        public final void setChain(String chain) {
            this.chain = chain;
        }

        public SslConfiguration build() {
            return new SslConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SslConfiguration> {
        public Builder certificate(String var1);

        public Builder privateKey(String var1);

        public Builder chain(String var1);
    }
}

