/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SelfUserProfileMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfUserProfile
implements StructuredPojo,
ToCopyableBuilder<Builder, SelfUserProfile> {
    private final String iamUserArn;
    private final String name;
    private final String sshUsername;
    private final String sshPublicKey;

    private SelfUserProfile(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
        this.name = builder.name;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String name() {
        return this.name;
    }

    public String sshUsername() {
        return this.sshUsername;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfUserProfile)) {
            return false;
        }
        SelfUserProfile other = (SelfUserProfile)obj;
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sshUsername(), other.sshUsername()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey());
    }

    public String toString() {
        return ToString.builder((String)"SelfUserProfile").add("IamUserArn", (Object)this.iamUserArn()).add("Name", (Object)this.name()).add("SshUsername", (Object)this.sshUsername()).add("SshPublicKey", (Object)this.sshPublicKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SshUsername": {
                return Optional.ofNullable(clazz.cast(this.sshUsername()));
            }
            case "SshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SelfUserProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String name;
        private String sshUsername;
        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfUserProfile model) {
            this.iamUserArn(model.iamUserArn);
            this.name(model.name);
            this.sshUsername(model.sshUsername);
            this.sshPublicKey(model.sshPublicKey);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSshUsername() {
            return this.sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public SelfUserProfile build() {
            return new SelfUserProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SelfUserProfile> {
        public Builder iamUserArn(String var1);

        public Builder name(String var1);

        public Builder sshUsername(String var1);

        public Builder sshPublicKey(String var1);
    }
}

