/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.RaidArrayMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RaidArray
implements StructuredPojo,
ToCopyableBuilder<Builder, RaidArray> {
    private final String raidArrayId;
    private final String instanceId;
    private final String name;
    private final Integer raidLevel;
    private final Integer numberOfDisks;
    private final Integer size;
    private final String device;
    private final String mountPoint;
    private final String availabilityZone;
    private final String createdAt;
    private final String stackId;
    private final String volumeType;
    private final Integer iops;

    private RaidArray(BuilderImpl builder) {
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.availabilityZone = builder.availabilityZone;
        this.createdAt = builder.createdAt;
        this.stackId = builder.stackId;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    public String raidArrayId() {
        return this.raidArrayId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String name() {
        return this.name;
    }

    public Integer raidLevel() {
        return this.raidLevel;
    }

    public Integer numberOfDisks() {
        return this.numberOfDisks;
    }

    public Integer size() {
        return this.size;
    }

    public String device() {
        return this.device;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String stackId() {
        return this.stackId;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.raidArrayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RaidArray)) {
            return false;
        }
        RaidArray other = (RaidArray)obj;
        return Objects.equals(this.raidArrayId(), other.raidArrayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.raidLevel(), other.raidLevel()) && Objects.equals(this.numberOfDisks(), other.numberOfDisks()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops());
    }

    public String toString() {
        return ToString.builder((String)"RaidArray").add("RaidArrayId", (Object)this.raidArrayId()).add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("RaidLevel", (Object)this.raidLevel()).add("NumberOfDisks", (Object)this.numberOfDisks()).add("Size", (Object)this.size()).add("Device", (Object)this.device()).add("MountPoint", (Object)this.mountPoint()).add("AvailabilityZone", (Object)this.availabilityZone()).add("CreatedAt", (Object)this.createdAt()).add("StackId", (Object)this.stackId()).add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RaidArrayId": {
                return Optional.ofNullable(clazz.cast(this.raidArrayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RaidLevel": {
                return Optional.ofNullable(clazz.cast(this.raidLevel()));
            }
            case "NumberOfDisks": {
                return Optional.ofNullable(clazz.cast(this.numberOfDisks()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "MountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RaidArrayMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String raidArrayId;
        private String instanceId;
        private String name;
        private Integer raidLevel;
        private Integer numberOfDisks;
        private Integer size;
        private String device;
        private String mountPoint;
        private String availabilityZone;
        private String createdAt;
        private String stackId;
        private String volumeType;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(RaidArray model) {
            this.raidArrayId(model.raidArrayId);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.raidLevel(model.raidLevel);
            this.numberOfDisks(model.numberOfDisks);
            this.size(model.size);
            this.device(model.device);
            this.mountPoint(model.mountPoint);
            this.availabilityZone(model.availabilityZone);
            this.createdAt(model.createdAt);
            this.stackId(model.stackId);
            this.volumeType(model.volumeType);
            this.iops(model.iops);
        }

        public final String getRaidArrayId() {
            return this.raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRaidLevel() {
            return this.raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return this.numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public RaidArray build() {
            return new RaidArray(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RaidArray> {
        public Builder raidArrayId(String var1);

        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder raidLevel(Integer var1);

        public Builder numberOfDisks(Integer var1);

        public Builder size(Integer var1);

        public Builder device(String var1);

        public Builder mountPoint(String var1);

        public Builder availabilityZone(String var1);

        public Builder createdAt(String var1);

        public Builder stackId(String var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);
    }
}

