/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLayersRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeLayersRequest> {
    private final String stackId;
    private final List<String> layerIds;

    private DescribeLayersRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersRequest)) {
            return false;
        }
        DescribeLayersRequest other = (DescribeLayersRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.layerIds(), other.layerIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLayersRequest").add("StackId", (Object)this.stackId()).add("LayerIds", this.layerIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "LayerIds": {
                return Optional.ofNullable(clazz.cast(this.layerIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.layerIds(model.layerIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLayersRequest build() {
            return new DescribeLayersRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeLayersRequest> {
        public Builder stackId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

