/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommand;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.transform.DeploymentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements StructuredPojo,
ToCopyableBuilder<Builder, Deployment> {
    private final String deploymentId;
    private final String stackId;
    private final String appId;
    private final String createdAt;
    private final String completedAt;
    private final Integer duration;
    private final String iamUserArn;
    private final String comment;
    private final DeploymentCommand command;
    private final String status;
    private final String customJson;
    private final List<String> instanceIds;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.duration = builder.duration;
        this.iamUserArn = builder.iamUserArn;
        this.comment = builder.comment;
        this.command = builder.command;
        this.status = builder.status;
        this.customJson = builder.customJson;
        this.instanceIds = builder.instanceIds;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String appId() {
        return this.appId;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String completedAt() {
        return this.completedAt;
    }

    public Integer duration() {
        return this.duration;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String comment() {
        return this.comment;
    }

    public DeploymentCommand command() {
        return this.command;
    }

    public String status() {
        return this.status;
    }

    public String customJson() {
        return this.customJson;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.customJson(), other.customJson()) && Objects.equals(this.instanceIds(), other.instanceIds());
    }

    public String toString() {
        return ToString.builder((String)"Deployment").add("DeploymentId", (Object)this.deploymentId()).add("StackId", (Object)this.stackId()).add("AppId", (Object)this.appId()).add("CreatedAt", (Object)this.createdAt()).add("CompletedAt", (Object)this.completedAt()).add("Duration", (Object)this.duration()).add("IamUserArn", (Object)this.iamUserArn()).add("Comment", (Object)this.comment()).add("Command", (Object)this.command()).add("Status", (Object)this.status()).add("CustomJson", (Object)this.customJson()).add("InstanceIds", this.instanceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CustomJson": {
                return Optional.ofNullable(clazz.cast(this.customJson()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String stackId;
        private String appId;
        private String createdAt;
        private String completedAt;
        private Integer duration;
        private String iamUserArn;
        private String comment;
        private DeploymentCommand command;
        private String status;
        private String customJson;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.deploymentId(model.deploymentId);
            this.stackId(model.stackId);
            this.appId(model.appId);
            this.createdAt(model.createdAt);
            this.completedAt(model.completedAt);
            this.duration(model.duration);
            this.iamUserArn(model.iamUserArn);
            this.comment(model.comment);
            this.command(model.command);
            this.status(model.status);
            this.customJson(model.customJson);
            this.instanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final DeploymentCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        public Deployment build() {
            return new Deployment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deployment> {
        public Builder deploymentId(String var1);

        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder createdAt(String var1);

        public Builder completedAt(String var1);

        public Builder duration(Integer var1);

        public Builder iamUserArn(String var1);

        public Builder comment(String var1);

        public Builder command(DeploymentCommand var1);

        default public Builder command(Consumer<DeploymentCommand.Builder> command) {
            return this.command((DeploymentCommand)((DeploymentCommand.Builder)DeploymentCommand.builder().applyMutation(command)).build());
        }

        public Builder status(String var1);

        public Builder customJson(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

