/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateElasticIpRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, AssociateElasticIpRequest> {
    private final String elasticIp;
    private final String instanceId;

    private AssociateElasticIpRequest(BuilderImpl builder) {
        super(builder);
        this.elasticIp = builder.elasticIp;
        this.instanceId = builder.instanceId;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateElasticIpRequest)) {
            return false;
        }
        AssociateElasticIpRequest other = (AssociateElasticIpRequest)((Object)obj);
        return Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateElasticIpRequest").add("ElasticIp", (Object)this.elasticIp()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticIp": {
                return Optional.ofNullable(clazz.cast(this.elasticIp()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String elasticIp;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateElasticIpRequest model) {
            super(model);
            this.elasticIp(model.elasticIp);
            this.instanceId(model.instanceId);
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateElasticIpRequest build() {
            return new AssociateElasticIpRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, AssociateElasticIpRequest> {
        public Builder elasticIp(String var1);

        public Builder instanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

